/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;

public class DefaultRedirectResolver
implements RedirectResolver {
    public String resolveRedirect(String requestedRedirect, ClientDetails client) throws OAuth2Exception {
        String redirectUri = client.getRegisteredRedirectUri();
        if (redirectUri != null && requestedRedirect != null) {
            if (!this.redirectMatches(requestedRedirect, redirectUri)) {
                throw new RedirectMismatchException("Invalid redirect: " + requestedRedirect + " does not match registered value: " + redirectUri);
            }
            redirectUri = requestedRedirect;
        }
        if (redirectUri == null) {
            if (requestedRedirect == null) {
                throw new OAuth2Exception("A redirect_uri must be supplied.");
            }
            redirectUri = requestedRedirect;
        }
        return redirectUri;
    }

    protected boolean redirectMatches(String requestedRedirect, String redirectUri) {
        return requestedRedirect.startsWith(redirectUri);
    }
}

