/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryClientDetailsService
implements ClientDetailsService {
    private Map<String, ? extends ClientDetails> clientDetailsStore = new HashMap<String, ClientDetails>();

    @Override
    public ClientDetails loadClientByClientId(String clientId) throws OAuth2Exception {
        ClientDetails details = this.clientDetailsStore.get(clientId);
        if (details == null) {
            throw new InvalidClientException("Client not found: " + clientId);
        }
        return details;
    }

    public Map<String, ? extends ClientDetails> getClientDetailsStore() {
        return this.clientDetailsStore;
    }

    public void setClientDetailsStore(Map<String, ? extends ClientDetails> clientDetailsStore) {
        this.clientDetailsStore = clientDetailsStore;
    }
}

