/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.TokenGranter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTokenGranter
implements TokenGranter {
    private final List<TokenGranter> tokenGranters;

    public CompositeTokenGranter(List<TokenGranter> tokenGranters) {
        this.tokenGranters = new ArrayList<TokenGranter>(tokenGranters);
    }

    @Override
    public OAuth2AccessToken grant(String grantType, Map<String, String> parameters, String clientId, Set<String> scope) {
        for (TokenGranter granter : this.tokenGranters) {
            OAuth2AccessToken grant = granter.grant(grantType, parameters, clientId, scope);
            if (grant == null) continue;
            return grant;
        }
        return null;
    }
}

