/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.http.converter.jaxb;

import java.util.Date;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.http.converter.jaxb.AbstractJaxbMessageConverter;
import org.springframework.security.oauth2.http.converter.jaxb.JaxbOAuth2AccessToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxbOAuth2AccessTokenMessageConverter
extends AbstractJaxbMessageConverter<JaxbOAuth2AccessToken, OAuth2AccessToken> {
    public JaxbOAuth2AccessTokenMessageConverter() {
        super(JaxbOAuth2AccessToken.class, OAuth2AccessToken.class);
    }

    @Override
    protected JaxbOAuth2AccessToken convertToInternal(OAuth2AccessToken accessToken) {
        JaxbOAuth2AccessToken jaxbAccessToken = new JaxbOAuth2AccessToken();
        jaxbAccessToken.setAccessToken(accessToken.getValue());
        jaxbAccessToken.setExpriation(accessToken.getExpiration());
        OAuth2RefreshToken refreshToken = accessToken.getRefreshToken();
        if (refreshToken != null) {
            jaxbAccessToken.setRefreshToken(refreshToken.getValue());
        }
        return jaxbAccessToken;
    }

    @Override
    protected OAuth2AccessToken convertToExternal(JaxbOAuth2AccessToken jaxbAccessToken) {
        Date expiration;
        OAuth2AccessToken accessToken = new OAuth2AccessToken(jaxbAccessToken.getAccessToken());
        String refreshToken = jaxbAccessToken.getRefreshToken();
        if (refreshToken != null) {
            accessToken.setRefreshToken(new OAuth2RefreshToken(refreshToken));
        }
        if ((expiration = jaxbAccessToken.getExpiration()) != null) {
            accessToken.setExpiration(expiration);
        }
        return accessToken;
    }
}

