/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.client.resource.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        if ("authorization_code".equals(element.getAttribute("type"))) {
            return AuthorizationCodeResourceDetails.class;
        }
        if ("client_credentials".equals(element.getAttribute("type"))) {
            return ClientCredentialsResourceDetails.class;
        }
        return BaseOAuth2ProtectedResourceDetails.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String scope;
        String requireImmediateAuthorization;
        String preEstablishedRedirectUri;
        String userAuthorizationUri;
        String clientAuthenticationScheme;
        String accessTokenUri;
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("An id must be supplied on a resource element.", (Object)element);
        }
        builder.addPropertyValue("id", (Object)id);
        String type = element.getAttribute("type");
        if (StringUtils.hasText((String)type)) {
            builder.addPropertyValue("grantType", (Object)type);
        }
        if (!StringUtils.hasText((String)(accessTokenUri = element.getAttribute("access-token-uri")))) {
            parserContext.getReaderContext().error("An accessTokenUri must be supplied on a resource element.", (Object)element);
        }
        builder.addPropertyValue("accessTokenUri", (Object)accessTokenUri);
        String clientId = element.getAttribute("client-id");
        if (!StringUtils.hasText((String)clientId)) {
            parserContext.getReaderContext().error("An clientId must be supplied on a resource element.", (Object)element);
        }
        builder.addPropertyValue("clientId", (Object)clientId);
        String clientSecret = element.getAttribute("client-secret");
        if (StringUtils.hasText((String)clientSecret)) {
            builder.addPropertyValue("clientSecret", (Object)clientSecret);
        }
        if (StringUtils.hasText((String)(clientAuthenticationScheme = element.getAttribute("client-authentication-scheme")))) {
            builder.addPropertyValue("clientAuthenticationScheme", (Object)clientAuthenticationScheme);
        }
        if (StringUtils.hasText((String)(userAuthorizationUri = element.getAttribute("user-authorization-uri")))) {
            if (type.equals("client_credentials")) {
                parserContext.getReaderContext().error("The client_credentials grant type does not accept an authorization URI", (Object)element);
            } else {
                builder.addPropertyValue("userAuthorizationUri", (Object)userAuthorizationUri);
            }
        }
        if (StringUtils.hasText((String)(preEstablishedRedirectUri = element.getAttribute("preEstablished-redirect-uri")))) {
            builder.addPropertyValue("preEstablishedRedirectUri", (Object)preEstablishedRedirectUri);
        }
        if (StringUtils.hasText((String)(requireImmediateAuthorization = element.getAttribute("require-immediate-authorization")))) {
            builder.addPropertyValue("requireImmediateAuthorization", (Object)requireImmediateAuthorization);
        }
        if (StringUtils.hasText((String)(scope = element.getAttribute("scope")))) {
            BeanDefinitionBuilder scopesBuilder = BeanDefinitionBuilder.genericBeanDefinition(StringListFactoryBean.class);
            scopesBuilder.addConstructorArgValue((Object)new TypedStringValue(scope));
            builder.addPropertyValue("scope", (Object)scopesBuilder.getBeanDefinition());
        }
        AuthenticationScheme btm = AuthenticationScheme.header;
        String bearerTokenMethod = element.getAttribute("authentication-scheme");
        if (StringUtils.hasText((String)bearerTokenMethod)) {
            btm = AuthenticationScheme.valueOf(bearerTokenMethod);
        }
        builder.addPropertyValue("authenticationScheme", (Object)btm);
        String bearerTokenName = element.getAttribute("token-name");
        if (!StringUtils.hasText((String)bearerTokenName)) {
            bearerTokenName = OAuth2AccessToken.ACCESS_TOKEN;
        }
        builder.addPropertyValue("tokenName", (Object)bearerTokenName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringListFactoryBean
    implements FactoryBean<List<String>> {
        private final String commaSeparatedList;

        public StringListFactoryBean(String commaSeparatedList) {
            this.commaSeparatedList = commaSeparatedList;
        }

        public List<String> getObject() throws Exception {
            return new ArrayList<String>(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)this.commaSeparatedList)));
        }

        public Class<?> getObjectType() {
            return List.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

