/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.filter.OAuth2ClientProcessingFilter;
import org.springframework.security.oauth2.client.filter.cache.HttpSessionAccessTokenCache;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.config.ConfigUtils;
import org.springframework.security.oauth2.config.ResourceDetailsServiceFactoryBean;
import org.springframework.security.oauth2.provider.filter.CompositeFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ClientBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String resourceDetailsServiceRef = element.getAttribute("resource-details-service-ref");
        String tokenCacheRef = element.getAttribute("token-cache-ref");
        String accessTokenProvider = element.getAttribute("token-provider-ref");
        String redirectStrategyRef = element.getAttribute("redirect-strategy-ref");
        String redirectOnError = element.getAttribute("redirect-on-error");
        if (!StringUtils.hasText((String)tokenCacheRef)) {
            tokenCacheRef = "oauth2ClientTokenCache";
            BeanDefinitionBuilder rememberMeServices = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionAccessTokenCache.class);
            parserContext.getRegistry().registerBeanDefinition(tokenCacheRef, (BeanDefinition)rememberMeServices.getBeanDefinition());
        }
        if (!StringUtils.hasText((String)resourceDetailsServiceRef)) {
            resourceDetailsServiceRef = "oauth2ResourceDetailsService";
            BeanDefinitionBuilder resourceDetailsService = BeanDefinitionBuilder.rootBeanDefinition(ResourceDetailsServiceFactoryBean.class);
            parserContext.getRegistry().registerBeanDefinition(resourceDetailsServiceRef, (BeanDefinition)resourceDetailsService.getBeanDefinition());
        }
        if (!StringUtils.hasText((String)accessTokenProvider)) {
            accessTokenProvider = "oauth2AccessTokenProvider";
            ManagedList profiles = new ManagedList();
            profiles.add((Object)BeanDefinitionBuilder.genericBeanDefinition(AuthorizationCodeAccessTokenProvider.class).getBeanDefinition());
            profiles.add((Object)BeanDefinitionBuilder.genericBeanDefinition(ClientCredentialsAccessTokenProvider.class).getBeanDefinition());
            BeanDefinitionBuilder profileManager = BeanDefinitionBuilder.rootBeanDefinition(AccessTokenProviderChain.class);
            profileManager.addConstructorArgValue((Object)profiles);
            parserContext.getRegistry().registerBeanDefinition(accessTokenProvider, (BeanDefinition)profileManager.getBeanDefinition());
        }
        BeanDefinitionBuilder clientContextFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ClientContextFilter.class);
        clientContextFilterBean.addPropertyReference("accessTokenProvider", accessTokenProvider);
        clientContextFilterBean.addPropertyReference("clientTokenCache", tokenCacheRef);
        if (StringUtils.hasText((String)redirectOnError)) {
            clientContextFilterBean.addPropertyValue("redirectOnError", (Object)redirectOnError);
        }
        if (StringUtils.hasText((String)redirectStrategyRef)) {
            clientContextFilterBean.addPropertyReference("redirectStrategy", redirectStrategyRef);
        }
        ManagedList filters = new ManagedList();
        parserContext.getRegistry().registerBeanDefinition("oauth2ClientContextFilter", (BeanDefinition)clientContextFilterBean.getBeanDefinition());
        filters.add((Object)new RuntimeBeanReference("oauth2ClientContextFilter"));
        BeanDefinition fids = ConfigUtils.createSecurityMetadataSource(element, parserContext);
        if (fids != null) {
            BeanDefinitionBuilder consumerFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ClientProcessingFilter.class);
            consumerFilterBean.addPropertyValue("objectDefinitionSource", (Object)fids);
            consumerFilterBean.addPropertyReference("resourceDetailsService", resourceDetailsServiceRef);
            parserContext.getRegistry().registerBeanDefinition("oauth2ClientSecurityFilter", (BeanDefinition)consumerFilterBean.getBeanDefinition());
            filters.add((Object)new RuntimeBeanReference("oauth2ClientSecurityFilter"));
        }
        BeanDefinitionBuilder filterChain = BeanDefinitionBuilder.rootBeanDefinition(CompositeFilter.class);
        filterChain.addPropertyValue("filters", (Object)filters);
        return filterChain.getBeanDefinition();
    }
}

