/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.expression;

import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth.provider.OAuthAuthenticationDetails;

@Deprecated
public class OAuthMethodSecurityExpressionHandler
extends DefaultMethodSecurityExpressionHandler {
    public StandardEvaluationContext createEvaluationContextInternal(Authentication auth, MethodInvocation mi) {
        StandardEvaluationContext ec = super.createEvaluationContextInternal(auth, mi);
        ec.addMethodResolver((MethodResolver)new OAuthMethodResolver());
        return ec;
    }

    public static boolean consumerHasAnyRole(SecurityExpressionRoot root, String ... roles) {
        OAuthAuthenticationDetails details;
        List<GrantedAuthority> consumerAuthorities;
        Authentication authentication = root.getAuthentication();
        if (authentication.getDetails() instanceof OAuthAuthenticationDetails && (consumerAuthorities = (details = (OAuthAuthenticationDetails)((Object)authentication.getDetails())).getConsumerDetails().getAuthorities()) != null) {
            Set roleSet = AuthorityUtils.authorityListToSet(consumerAuthorities);
            for (String role : roles) {
                if (!roleSet.contains(role)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOAuthConsumerAuth(SecurityExpressionRoot root) {
        Authentication authentication = root.getAuthentication();
        return authentication.getDetails() instanceof OAuthAuthenticationDetails;
    }

    private static class DenyOAuthClientRoleExecutor
    implements MethodExecutor {
        private DenyOAuthClientRoleExecutor() {
        }

        public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
            return new TypedValue((Object)(!OAuthMethodSecurityExpressionHandler.isOAuthConsumerAuth((SecurityExpressionRoot)target) ? 1 : 0));
        }
    }

    private static class OAuthClientRoleExecutor
    implements MethodExecutor {
        private OAuthClientRoleExecutor() {
        }

        public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
            String[] roles = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                roles[i] = String.valueOf(arguments[i]);
            }
            return new TypedValue((Object)OAuthMethodSecurityExpressionHandler.consumerHasAnyRole((SecurityExpressionRoot)target, roles));
        }
    }

    private static class OAuthMethodResolver
    implements MethodResolver {
        private OAuthMethodResolver() {
        }

        public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
            if (targetObject instanceof SecurityExpressionRoot) {
                if ("oauthConsumerHasRole".equals(name) || "oauthConsumerHasAnyRole".equals(name)) {
                    return new OAuthClientRoleExecutor();
                }
                if ("denyOAuthConsumer".equals(name)) {
                    return new DenyOAuthClientRoleExecutor();
                }
            }
            return null;
        }
    }
}

