/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.config;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth.common.signature.RSAKeySecret;
import org.springframework.security.oauth.common.signature.SharedConsumerSecretImpl;
import org.springframework.security.oauth.common.signature.SignatureSecret;
import org.springframework.security.oauth.provider.BaseConsumerDetails;
import org.springframework.security.oauth.provider.ConsumerDetails;

@Deprecated
public class ConsumerDetailsFactoryBean
implements FactoryBean<ConsumerDetails>,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(ConsumerDetailsFactoryBean.class);
    private Object typeOfSecret;
    private BaseConsumerDetails consumer = new BaseConsumerDetails();
    private String secret;
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumer.setConsumerKey(consumerKey);
    }

    public void setConsumerName(String consumerName) {
        this.consumer.setConsumerName(consumerName);
    }

    public void setSignatureSecret(SignatureSecret signatureSecret) {
        this.consumer.setSignatureSecret(signatureSecret);
    }

    public void setAuthorities(String authorities) {
        this.consumer.setAuthorities(AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities));
    }

    public void setResourceName(String resourceName) {
        this.consumer.setResourceName(resourceName);
    }

    public void setResourceDescription(String resourceDescription) {
        this.consumer.setResourceDescription(resourceDescription);
    }

    public void setRequiredToObtainAuthenticatedToken(boolean requiredToObtainAuthenticatedToken) {
        this.consumer.setRequiredToObtainAuthenticatedToken(requiredToObtainAuthenticatedToken);
    }

    public void setTypeOfSecret(Object typeOfSecret) {
        this.typeOfSecret = typeOfSecret;
    }

    public ConsumerDetails getObject() throws Exception {
        if ("rsa-cert".equals(this.typeOfSecret)) {
            InputStream inputStream = null;
            try {
                inputStream = this.resourceLoader.getResource(this.secret).getInputStream();
                Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
                this.consumer.setSignatureSecret(new RSAKeySecret(cert.getPublicKey()));
            }
            catch (IOException e) {
                throw new BeanCreationException("RSA certificate not found at " + this.secret + ".", (Throwable)e);
            }
            catch (CertificateException e) {
                throw new BeanCreationException("Invalid RSA certificate at " + this.secret + ".", (Throwable)e);
            }
            catch (NullPointerException e) {
                throw new BeanCreationException("Could not load RSA certificate at " + this.secret + ".", (Throwable)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Cannot close open stream: ", (Throwable)e);
                }
            }
        }
        this.consumer.setSignatureSecret(new SharedConsumerSecretImpl(this.secret));
        return this.consumer;
    }

    public Class<?> getObjectType() {
        return BaseConsumerDetails.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

