/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.common;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;

public class OAuthCodec
extends URLCodec {
    protected static final BitSet SAFE_CHARACTERS = (BitSet)URLCodec.WWW_FORM_URL.clone();

    static {
        SAFE_CHARACTERS.clear(42);
        SAFE_CHARACTERS.clear(32);
        SAFE_CHARACTERS.set(126);
    }

    private OAuthCodec() {
    }

    public static String oauthEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return new String(URLCodec.encodeUrl((BitSet)SAFE_CHARACTERS, (byte[])value.getBytes("UTF-8")), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String oauthDecode(String value) throws DecoderException {
        if (value == null) {
            return "";
        }
        try {
            return new String(URLCodec.decodeUrl((byte[])value.getBytes("US-ASCII")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

