/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.token;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.security.oauth.provider.token.InMemoryProviderTokenServices;
import org.springframework.security.oauth.provider.token.OAuthProviderTokenImpl;

public class InMemorySelfCleaningProviderTokenServices
extends InMemoryProviderTokenServices
implements DisposableBean {
    private ScheduledExecutorService scheduler;
    private Integer cleanupIntervalSeconds;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.cleanupIntervalSeconds == null) {
            this.cleanupIntervalSeconds = 3600;
        }
        if (this.cleanupIntervalSeconds > 0) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            Runnable cleanupLogic = new Runnable(){

                @Override
                public void run() {
                    Iterator entriesIt = InMemorySelfCleaningProviderTokenServices.this.tokenStore.entrySet().iterator();
                    while (entriesIt.hasNext()) {
                        Map.Entry entry = entriesIt.next();
                        OAuthProviderTokenImpl tokenImpl = (OAuthProviderTokenImpl)entry.getValue();
                        if (!InMemorySelfCleaningProviderTokenServices.this.isExpired(tokenImpl)) continue;
                        entriesIt.remove();
                        InMemorySelfCleaningProviderTokenServices.this.onTokenRemoved(tokenImpl);
                    }
                }
            };
            this.scheduler.scheduleAtFixedRate(cleanupLogic, this.getAccessTokenValiditySeconds(), this.cleanupIntervalSeconds.intValue(), TimeUnit.SECONDS);
        }
    }

    public void destroy() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public Integer getCleanupIntervalSeconds() {
        return this.cleanupIntervalSeconds;
    }

    public void setCleanupIntervalSeconds(Integer cleanupIntervalSeconds) {
        this.cleanupIntervalSeconds = cleanupIntervalSeconds;
    }
}

