/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.attributes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.AbstractFallbackMethodSecurityMetadataSource;
import org.springframework.security.oauth.provider.attributes.ConsumerKeysAllowed;
import org.springframework.security.oauth.provider.attributes.ConsumerRolesAllowed;
import org.springframework.security.oauth.provider.attributes.ConsumerSecurityConfig;
import org.springframework.security.oauth.provider.attributes.DenyAllConsumers;
import org.springframework.security.oauth.provider.attributes.PermitAllConsumers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerSecurityMetadataSource
extends AbstractFallbackMethodSecurityMetadataSource {
    protected List<ConfigAttribute> findAttributes(Class<?> clazz) {
        return this.processAnnotations(clazz.getAnnotations());
    }

    protected List<ConfigAttribute> findAttributes(Method method, Class<?> targetClass) {
        return this.processAnnotations(AnnotationUtils.getAnnotations((Method)method));
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    private List<ConfigAttribute> processAnnotations(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        ArrayList<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
        for (Annotation a : annotations) {
            if (a instanceof DenyAllConsumers) {
                attributes.add((ConfigAttribute)ConsumerSecurityConfig.DENY_ALL_ATTRIBUTE);
                return attributes;
            }
            if (a instanceof PermitAllConsumers) {
                attributes.add((ConfigAttribute)ConsumerSecurityConfig.PERMIT_ALL_ATTRIBUTE);
                return attributes;
            }
            if (a instanceof ConsumerRolesAllowed) {
                ConsumerRolesAllowed ra = (ConsumerRolesAllowed)a;
                for (String role : ra.value()) {
                    attributes.add((ConfigAttribute)new ConsumerSecurityConfig(role, ConsumerSecurityConfig.ConsumerSecurityType.CONSUMER_ROLE));
                }
                return attributes;
            }
            if (!(a instanceof ConsumerKeysAllowed)) continue;
            ConsumerKeysAllowed ka = (ConsumerKeysAllowed)a;
            for (String key : ka.value()) {
                attributes.add((ConfigAttribute)new ConsumerSecurityConfig(key, ConsumerSecurityConfig.ConsumerSecurityType.CONSUMER_KEY));
            }
            return attributes;
        }
        return null;
    }
}

