/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.RandomValueOAuth2ProviderTokenServices;

public class InMemoryOAuth2ProviderTokenServices
extends RandomValueOAuth2ProviderTokenServices {
    protected final ConcurrentHashMap<String, OAuth2AccessToken> accessTokenStore = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, ExpiringOAuth2RefreshToken> refreshTokenStore = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, OAuth2Authentication> authenticationStore = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, String> refreshTokenAssociation = new ConcurrentHashMap();

    protected OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.authenticationStore.get(token.getValue());
    }

    protected void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        this.accessTokenStore.put(token.getValue(), token);
        this.authenticationStore.put(token.getValue(), authentication);
        if (token.getRefreshToken() != null && token.getRefreshToken().getValue() != null) {
            this.refreshTokenAssociation.put(token.getRefreshToken().getValue(), token.getValue());
        }
    }

    protected OAuth2AccessToken readAccessToken(String tokenValue) {
        return this.accessTokenStore.get(tokenValue);
    }

    protected void removeAccessToken(String tokenValue) {
        this.accessTokenStore.remove(tokenValue);
        this.authenticationStore.remove(tokenValue);
    }

    protected OAuth2Authentication readAuthentication(ExpiringOAuth2RefreshToken token) {
        return this.authenticationStore.get(token.getValue());
    }

    protected void storeRefreshToken(ExpiringOAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        this.refreshTokenStore.put(refreshToken.getValue(), refreshToken);
        this.authenticationStore.put(refreshToken.getValue(), authentication);
    }

    protected ExpiringOAuth2RefreshToken readRefreshToken(String tokenValue) {
        return this.refreshTokenStore.get(tokenValue);
    }

    protected void removeRefreshToken(String tokenValue) {
        this.refreshTokenStore.remove(tokenValue);
        this.authenticationStore.remove(tokenValue);
    }

    protected void removeAccessTokenUsingRefreshToken(String refreshToken) {
        String accessToken = this.refreshTokenAssociation.remove(refreshToken);
        if (accessToken != null) {
            this.accessTokenStore.remove(accessToken);
        }
    }
}

