/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.refresh;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.refresh.RefreshAuthenticationToken;
import org.springframework.security.oauth2.provider.refresh.RefreshTokenDetails;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private AuthenticationManager authenticationManager;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An authentication manager must be provided.");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        RefreshAuthenticationToken auth = (RefreshAuthenticationToken)authentication;
        Authentication clientAuth = this.getAuthenticationManager().authenticate((Authentication)auth.getClientAuthentication());
        if (!(clientAuth instanceof AbstractAuthenticationToken)) {
            throw new IllegalStateException("Client authentication must be an AbstractAuthenticationToken in order to support the refresh token.");
        }
        ((AbstractAuthenticationToken)clientAuth).setDetails((Object)new RefreshTokenDetails(auth.getRefreshToken()));
        return new OAuth2Authentication<Authentication, Object>(clientAuth, null);
    }

    public boolean supports(Class<?> authentication) {
        return RefreshAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

