/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer.rememberme;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.consumer.rememberme.OAuth2RememberMeServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionOAuth2RememberMeServices
implements OAuth2RememberMeServices {
    public static final String REMEMBERED_TOKENS_KEY = HttpSessionOAuth2RememberMeServices.class.getName() + "#REMEMBERED_TOKENS";
    public static final String STATE_PREFIX = HttpSessionOAuth2RememberMeServices.class.getName() + "#STATE#";
    public static final String GLOBAL_STATE_KEY = HttpSessionOAuth2RememberMeServices.class.getName() + "GLOBAL";

    @Override
    public Map<String, OAuth2AccessToken> loadRememberedTokens(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        Map rememberedTokens = null;
        if (session != null) {
            rememberedTokens = (Map)session.getAttribute(REMEMBERED_TOKENS_KEY);
        }
        return rememberedTokens;
    }

    @Override
    public void rememberTokens(Map<String, OAuth2AccessToken> tokens, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.setAttribute(REMEMBERED_TOKENS_KEY, tokens);
        }
    }

    @Override
    public Object loadPreservedState(String stateKey, HttpServletRequest request, HttpServletResponse response) {
        Object state = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            if (stateKey == null) {
                stateKey = GLOBAL_STATE_KEY;
            }
            state = session.getAttribute(STATE_PREFIX + stateKey);
        }
        return state;
    }

    @Override
    public void preserveState(String id, Object state, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            if (id == null) {
                id = GLOBAL_STATE_KEY;
            }
            session.setAttribute(STATE_PREFIX + id, state);
        }
    }
}

