/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.consumer.OAuth2AccessTokenRequiredException;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetailsService;
import org.springframework.security.oauth2.consumer.OAuth2SecurityContext;
import org.springframework.security.oauth2.consumer.OAuth2SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ClientProcessingFilter
implements Filter,
InitializingBean,
MessageSourceAware {
    public static final String ACCESS_TOKENS_DEFAULT_ATTRIBUTE = "OAUTH_ACCESS_TOKENS";
    private static final Log LOG = LogFactory.getLog(OAuth2ClientProcessingFilter.class);
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private FilterInvocationSecurityMetadataSource objectDefinitionSource;
    private String accessTokensRequestAttribute = "OAUTH_ACCESS_TOKENS";
    private OAuth2ProtectedResourceDetailsService resourceDetailsService;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.objectDefinitionSource, (String)"The object definition source must be configured.");
        Assert.notNull((Object)this.resourceDetailsService, (String)"A resource details service must be configured for the client processing filter.");
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Set<String> resourceDependencies = this.getResourceDependencies(request, response, chain);
        if (!resourceDependencies.isEmpty()) {
            OAuth2SecurityContext context = OAuth2SecurityContextHolder.getContext();
            if (context == null) {
                throw new IllegalStateException("An OAuth2 security context hasn't been established. Unable to load the access tokens for the following resources: " + resourceDependencies);
            }
            Map<String, OAuth2AccessToken> accessTokens = context.getAccessTokens();
            ArrayList<OAuth2AccessToken> tokens = new ArrayList<OAuth2AccessToken>();
            for (String dependency : resourceDependencies) {
                OAuth2AccessToken accessToken;
                OAuth2ProtectedResourceDetails resource = this.getResourceDetailsService().loadProtectedResourceDetailsById(dependency);
                if (resource == null) {
                    throw new IllegalStateException("Unknown resource: " + dependency);
                }
                OAuth2AccessToken oAuth2AccessToken = accessToken = accessTokens == null ? null : accessTokens.get(dependency);
                if (accessToken == null) {
                    throw new OAuth2AccessTokenRequiredException("Access token for resource '" + dependency + "' has not been obtained.", resource);
                }
                tokens.add(accessToken);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing access tokens in request attribute '" + this.getAccessTokensRequestAttribute() + "'."));
            }
            request.setAttribute(this.getAccessTokensRequestAttribute(), tokens);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No access token dependencies for request.");
            }
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    protected Set<String> getResourceDependencies(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        TreeSet<String> deps = new TreeSet<String>();
        if (this.getObjectDefinitionSource() != null) {
            FilterInvocation invocation = new FilterInvocation((ServletRequest)request, (ServletResponse)response, filterChain);
            Collection attributes = this.getObjectDefinitionSource().getAttributes((Object)invocation);
            if (attributes != null) {
                for (ConfigAttribute attribute : attributes) {
                    deps.add(attribute.getAttribute());
                }
            }
        }
        return deps;
    }

    public FilterInvocationSecurityMetadataSource getObjectDefinitionSource() {
        return this.objectDefinitionSource;
    }

    public void setObjectDefinitionSource(FilterInvocationSecurityMetadataSource objectDefinitionSource) {
        this.objectDefinitionSource = objectDefinitionSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public String getAccessTokensRequestAttribute() {
        return this.accessTokensRequestAttribute;
    }

    public void setAccessTokensRequestAttribute(String accessTokensRequestAttribute) {
        this.accessTokensRequestAttribute = accessTokensRequestAttribute;
    }

    public OAuth2ProtectedResourceDetailsService getResourceDetailsService() {
        return this.resourceDetailsService;
    }

    public void setResourceDetailsService(OAuth2ProtectedResourceDetailsService resourceDetailsService) {
        this.resourceDetailsService = resourceDetailsService;
    }
}

