/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.consumer.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.consumer.OAuth2AccessTokenSupport;
import org.springframework.security.oauth2.consumer.OAuth2ProfileManager;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.consumer.UserRedirectRequiredException;
import org.springframework.security.oauth2.consumer.token.InMemoryOAuth2ClientTokenServices;
import org.springframework.security.oauth2.consumer.token.OAuth2ClientTokenServices;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractOAuth2ProfileManager
extends OAuth2AccessTokenSupport
implements OAuth2ProfileManager,
InitializingBean {
    private OAuth2ClientTokenServices tokenServices = new InMemoryOAuth2ClientTokenServices();
    private boolean requireAuthenticated = true;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.tokenServices, (String)"OAuth2 token services is required.");
    }

    public OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails resource) throws UserRedirectRequiredException, AccessDeniedException {
        OAuth2AccessToken accessToken = null;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (this.isRequireAuthenticated() && (auth == null || !auth.isAuthenticated())) {
            throw new OAuth2AccessDeniedException("An authenticated context is required for the current user in order to obtain an access token.", resource);
        }
        OAuth2AccessToken existingToken = this.getTokenServices().getToken(auth, resource);
        if (existingToken != null) {
            if (this.isExpired(existingToken)) {
                OAuth2RefreshToken refreshToken = existingToken.getRefreshToken();
                if (refreshToken != null) {
                    accessToken = this.obtainAccessToken(resource, refreshToken);
                }
            } else {
                accessToken = existingToken;
            }
        }
        if (accessToken == null && (accessToken = this.obtainNewAccessToken(resource)) == null) {
            throw new IllegalStateException("An OAuth 2 access token must be obtained or an exception thrown.");
        }
        if (!accessToken.equals(existingToken)) {
            if (existingToken == null) {
                this.getTokenServices().storeToken(auth, resource, accessToken);
            } else {
                this.getTokenServices().updateToken(auth, resource, existingToken, accessToken);
            }
        }
        return accessToken;
    }

    protected abstract OAuth2AccessToken obtainNewAccessToken(OAuth2ProtectedResourceDetails var1) throws UserRedirectRequiredException, AccessDeniedException;

    protected OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails resource, OAuth2RefreshToken refreshToken) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"refresh_token");
        form.add((Object)"client_id", (Object)resource.getClientId());
        form.add((Object)"refresh_token", (Object)refreshToken.getValue());
        return this.retrieveToken((MultiValueMap<String, String>)form, resource);
    }

    protected boolean isExpired(OAuth2AccessToken token) {
        return token.getExpiration() == null || token.getExpiration().getTime() < System.currentTimeMillis();
    }

    public OAuth2ClientTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public void setTokenServices(OAuth2ClientTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public boolean isRequireAuthenticated() {
        return this.requireAuthenticated;
    }

    public void setRequireAuthenticated(boolean requireAuthenticated) {
        this.requireAuthenticated = requireAuthenticated;
    }
}

