/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.nonce;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth.provider.ConsumerDetails;
import org.springframework.security.oauth.provider.nonce.ExpiringTimestampNonceServices;
import org.springframework.security.oauth.provider.nonce.NonceAlreadyUsedException;

public class InMemoryNonceServices
extends ExpiringTimestampNonceServices {
    protected static final ConcurrentMap<String, LinkedList<TimestampEntry>> TIMESTAMP_ENTRIES = new ConcurrentHashMap<String, LinkedList<TimestampEntry>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateNonce(ConsumerDetails consumerDetails, long timestamp, String nonce) throws AuthenticationException {
        long cutoff = System.currentTimeMillis() / 1000L - this.getValidityWindowSeconds();
        super.validateNonce(consumerDetails, timestamp, nonce);
        String consumerKey = consumerDetails.getConsumerKey();
        LinkedList<TimestampEntry> entries = (LinkedList<TimestampEntry>)TIMESTAMP_ENTRIES.get(consumerKey);
        if (entries == null) {
            entries = new LinkedList<TimestampEntry>();
            TIMESTAMP_ENTRIES.put(consumerKey, entries);
        }
        LinkedList<TimestampEntry> linkedList = entries;
        synchronized (linkedList) {
            if (entries.isEmpty()) {
                entries.add(new TimestampEntry(timestamp, nonce));
            } else {
                boolean isNew = ((TimestampEntry)entries.getLast()).getTimestamp() < timestamp;
                ListIterator listIterator = entries.listIterator();
                while (listIterator.hasNext()) {
                    TimestampEntry entry = (TimestampEntry)listIterator.next();
                    if (entry.getTimestamp() < cutoff) {
                        listIterator.remove();
                        isNew = !listIterator.hasNext();
                        continue;
                    }
                    if (isNew) {
                        entries.addLast(new TimestampEntry(timestamp, nonce));
                        return;
                    }
                    if (entry.getTimestamp() == timestamp) {
                        if (!entry.addNonce(nonce)) {
                            throw new NonceAlreadyUsedException("Nonce already used: " + nonce);
                        }
                        return;
                    }
                    if (entry.getTimestamp() <= timestamp) continue;
                    entries.add(listIterator.previousIndex(), new TimestampEntry(timestamp, nonce));
                    return;
                }
                entries.addLast(new TimestampEntry(timestamp, nonce));
            }
        }
    }

    protected static class TimestampEntry {
        private final Long timestamp;
        private final Set<String> nonces = new HashSet<String>();

        public TimestampEntry(long timestamp, String firstNonce) {
            this.timestamp = timestamp;
            this.nonces.add(firstNonce);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addNonce(String nonce) {
            Set<String> set = this.nonces;
            synchronized (set) {
                return this.nonces.add(nonce);
            }
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            return this.timestamp.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TimestampEntry && this.timestamp.equals(((TimestampEntry)obj).timestamp);
        }
    }
}

