/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.consumer.rememberme;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.oauth.consumer.rememberme.OAuthRememberMeServices;
import org.springframework.security.oauth.consumer.token.OAuthConsumerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionOAuthRememberMeServices
implements OAuthRememberMeServices {
    public static final String REMEMBERED_TOKENS_KEY = HttpSessionOAuthRememberMeServices.class.getName() + "#REMEMBERED_TOKENS";

    @Override
    public Map<String, OAuthConsumerToken> loadRememberedTokens(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        Map rememberedTokens = null;
        if (session != null) {
            rememberedTokens = (Map)session.getAttribute(REMEMBERED_TOKENS_KEY);
        }
        return rememberedTokens;
    }

    @Override
    public void rememberTokens(Map<String, OAuthConsumerToken> tokens, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.setAttribute(REMEMBERED_TOKENS_KEY, tokens);
        }
    }
}

