/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.consumer;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth.consumer.AccessTokenRequiredException;
import org.springframework.security.oauth.consumer.OAuthSecurityContext;
import org.springframework.security.oauth.consumer.OAuthSecurityContextHolder;
import org.springframework.security.oauth.consumer.ProtectedResourceDetailsService;
import org.springframework.security.oauth.consumer.token.OAuthConsumerToken;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthConsumerProcessingFilter
implements Filter,
InitializingBean,
MessageSourceAware {
    private static final Log LOG = LogFactory.getLog(OAuthConsumerProcessingFilter.class);
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private FilterInvocationSecurityMetadataSource objectDefinitionSource;
    private boolean requireAuthenticated = true;
    private ProtectedResourceDetailsService protectedResourceDetailsService;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.protectedResourceDetailsService, (String)"A protected resource details service is required.");
        Assert.notNull((Object)this.objectDefinitionSource, (String)"The object definition source must be configured.");
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Set<String> accessTokenDeps = this.getAccessTokenDependencies(request, response, chain);
        if (!accessTokenDeps.isEmpty()) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (this.isRequireAuthenticated() && !authentication.isAuthenticated()) {
                throw new InsufficientAuthenticationException("An authenticated principal must be present.");
            }
            OAuthSecurityContext context = OAuthSecurityContextHolder.getContext();
            if (context == null) {
                throw new IllegalStateException("No OAuth security context has been established. Unable to access resources.");
            }
            Map<String, OAuthConsumerToken> accessTokens = context.getAccessTokens();
            for (String dependency : accessTokenDeps) {
                if (accessTokens.containsKey(dependency)) continue;
                throw new AccessTokenRequiredException(this.getProtectedResourceDetailsService().loadProtectedResourceDetailsById(dependency));
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No access token dependencies for request.");
            }
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    protected Set<String> getAccessTokenDependencies(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        TreeSet<String> deps = new TreeSet<String>();
        if (this.getObjectDefinitionSource() != null) {
            FilterInvocation invocation = new FilterInvocation((ServletRequest)request, (ServletResponse)response, filterChain);
            Collection attributes = this.getObjectDefinitionSource().getAttributes((Object)invocation);
            if (attributes != null) {
                for (ConfigAttribute attribute : attributes) {
                    deps.add(attribute.getAttribute());
                }
            }
        }
        return deps;
    }

    public ProtectedResourceDetailsService getProtectedResourceDetailsService() {
        return this.protectedResourceDetailsService;
    }

    @Autowired
    public void setProtectedResourceDetailsService(ProtectedResourceDetailsService protectedResourceDetailsService) {
        this.protectedResourceDetailsService = protectedResourceDetailsService;
    }

    public FilterInvocationSecurityMetadataSource getObjectDefinitionSource() {
        return this.objectDefinitionSource;
    }

    public void setObjectDefinitionSource(FilterInvocationSecurityMetadataSource objectDefinitionSource) {
        this.objectDefinitionSource = objectDefinitionSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public boolean isRequireAuthenticated() {
        return this.requireAuthenticated;
    }

    public void setRequireAuthenticated(boolean requireAuthenticated) {
        this.requireAuthenticated = requireAuthenticated;
    }
}

