/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.verification;

import java.security.SecureRandom;
import java.util.Random;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.verification.VerificationCodeAuthenticationToken;
import org.springframework.security.oauth2.provider.verification.VerificationCodeServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RandomValueVerificationCodeServices
implements VerificationCodeServices,
InitializingBean {
    private static final char[] DEFAULT_CODEC = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private Random random;
    private int codeLengthBytes = 6;

    public void afterPropertiesSet() throws Exception {
        if (this.getRandom() == null) {
            this.setRandom(new SecureRandom());
        }
    }

    protected abstract void store(String var1, OAuth2Authentication<? extends VerificationCodeAuthenticationToken, ? extends Authentication> var2);

    @Override
    public String createVerificationCode(OAuth2Authentication<? extends VerificationCodeAuthenticationToken, ? extends Authentication> authentication) {
        String code = this.createVerificationCode();
        this.store(code, authentication);
        return code;
    }

    public String createVerificationCode() {
        byte[] verifierBytes = new byte[this.getCodeLengthBytes()];
        this.getRandom().nextBytes(verifierBytes);
        return this.getVerificationCodeString(verifierBytes);
    }

    protected String getVerificationCodeString(byte[] verifierBytes) {
        char[] chars = new char[verifierBytes.length];
        for (int i = 0; i < verifierBytes.length; ++i) {
            chars[i] = DEFAULT_CODEC[(verifierBytes[i] & 0xFF) % DEFAULT_CODEC.length];
        }
        return new String(chars);
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public int getCodeLengthBytes() {
        return this.codeLengthBytes;
    }

    public void setCodeLengthBytes(int codeLengthBytes) {
        this.codeLengthBytes = codeLengthBytes;
    }
}

