/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.verification;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.verification.RandomValueVerificationCodeServices;
import org.springframework.security.oauth2.provider.verification.VerificationCodeAuthenticationToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryVerificationCodeServices
extends RandomValueVerificationCodeServices {
    protected final ConcurrentHashMap<String, OAuth2Authentication<? extends VerificationCodeAuthenticationToken, ? extends Authentication>> verificationStore = new ConcurrentHashMap();

    @Override
    protected void store(String code, OAuth2Authentication<? extends VerificationCodeAuthenticationToken, ? extends Authentication> authentication) {
        this.verificationStore.put(code, authentication);
    }

    @Override
    public OAuth2Authentication<? extends VerificationCodeAuthenticationToken, ? extends Authentication> consumeVerificationCode(String code) throws InvalidGrantException {
        OAuth2Authentication<? extends VerificationCodeAuthenticationToken, ? extends Authentication> auth = this.verificationStore.remove(code);
        if (auth == null) {
            throw new InvalidGrantException("Invalid verification code: " + code);
        }
        return auth;
    }
}

