/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.exceptions.ExpiredTokenException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientAuthenticationToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.OAuth2ProviderTokenServices;

public abstract class RandomValueOAuth2ProviderTokenServices
implements OAuth2ProviderTokenServices,
InitializingBean {
    private Random random;
    private int refreshTokenValiditySeconds = 2592000;
    private int accessTokenValiditySeconds = 43200;
    private boolean supportRefreshToken = false;
    private boolean reuseRefreshToken = true;
    private int tokenSecretLengthBytes = 80;

    public void afterPropertiesSet() throws Exception {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    protected abstract OAuth2Authentication readAuthentication(OAuth2AccessToken var1);

    protected abstract void storeAccessToken(OAuth2AccessToken var1, OAuth2Authentication var2);

    protected abstract OAuth2AccessToken readAccessToken(String var1);

    protected abstract void removeAccessToken(String var1);

    protected abstract OAuth2Authentication readAuthentication(ExpiringOAuth2RefreshToken var1);

    protected abstract void storeRefreshToken(ExpiringOAuth2RefreshToken var1, OAuth2Authentication var2);

    protected abstract ExpiringOAuth2RefreshToken readRefreshToken(String var1);

    protected abstract void removeRefreshToken(String var1);

    protected abstract void removeAccessTokenUsingRefreshToken(String var1);

    public OAuth2AccessToken createAccessToken(OAuth2Authentication authentication) throws AuthenticationException {
        ExpiringOAuth2RefreshToken refreshToken = null;
        if (this.isSupportRefreshToken()) {
            refreshToken = this.createRefreshToken(authentication);
        }
        return this.createAccessToken(authentication, refreshToken);
    }

    public OAuth2AccessToken refreshAccessToken(String refreshTokenValue) throws AuthenticationException {
        if (!this.isSupportRefreshToken()) {
            throw new InvalidTokenException("Invalid refresh token: " + refreshTokenValue);
        }
        this.removeAccessTokenUsingRefreshToken(refreshTokenValue);
        ExpiringOAuth2RefreshToken refreshToken = this.readRefreshToken(refreshTokenValue);
        if (refreshToken == null) {
            throw new InvalidTokenException("Invalid refresh token: " + refreshTokenValue);
        }
        if (this.isExpired(refreshToken)) {
            this.removeRefreshToken(refreshTokenValue);
            throw new ExpiredTokenException("Expired refresh token: " + refreshToken);
        }
        OAuth2Authentication authentication = this.readAuthentication(refreshToken);
        if (!this.isReuseRefreshToken()) {
            this.removeRefreshToken(refreshTokenValue);
            refreshToken = this.createRefreshToken(authentication);
        }
        return this.createAccessToken(authentication, refreshToken);
    }

    protected boolean isExpired(ExpiringOAuth2RefreshToken refreshToken) {
        return refreshToken.getExpiration() == null || System.currentTimeMillis() > refreshToken.getExpiration().getTime();
    }

    private boolean isExpired(OAuth2AccessToken accessToken) {
        return accessToken.getExpiration() == null || System.currentTimeMillis() > accessToken.getExpiration().getTime();
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) throws AuthenticationException {
        OAuth2AccessToken accessToken = this.readAccessToken(accessTokenValue);
        if (accessToken == null) {
            throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
        }
        if (this.isExpired(accessToken)) {
            this.removeAccessToken(accessTokenValue);
            throw new ExpiredTokenException("Expired access token: " + accessTokenValue);
        }
        return this.readAuthentication(accessToken);
    }

    protected ExpiringOAuth2RefreshToken createRefreshToken(OAuth2Authentication authentication) {
        ExpiringOAuth2RefreshToken refreshToken = new ExpiringOAuth2RefreshToken();
        String refreshTokenValue = UUID.randomUUID().toString();
        refreshToken.setValue(refreshTokenValue);
        refreshToken.setExpiration(new Date(System.currentTimeMillis() + (long)this.getRefreshTokenValiditySeconds() * 1000L));
        this.storeRefreshToken(refreshToken, authentication);
        return refreshToken;
    }

    protected OAuth2AccessToken createAccessToken(OAuth2Authentication authentication, OAuth2RefreshToken refreshToken) {
        OAuth2AccessToken token = new OAuth2AccessToken();
        String tokenValue = UUID.randomUUID().toString();
        token.setValue(tokenValue);
        token.setExpiration(new Date(System.currentTimeMillis() + (long)this.getAccessTokenValiditySeconds() * 1000L));
        token.setRefreshToken(refreshToken);
        if (authentication.getClientAuthentication() instanceof ClientAuthenticationToken) {
            token.setScope(((ClientAuthenticationToken)((Object)authentication.getClientAuthentication())).getScope());
        }
        this.storeAccessToken(token, authentication);
        return token;
    }

    public int getTokenSecretLengthBytes() {
        return this.tokenSecretLengthBytes;
    }

    public void setTokenSecretLengthBytes(int tokenSecretLengthBytes) {
        this.tokenSecretLengthBytes = tokenSecretLengthBytes;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public int getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public int getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(int accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    public boolean isSupportRefreshToken() {
        return this.supportRefreshToken;
    }

    public void setSupportRefreshToken(boolean supportRefreshToken) {
        this.supportRefreshToken = supportRefreshToken;
    }

    public boolean isReuseRefreshToken() {
        return this.reuseRefreshToken;
    }

    public void setReuseRefreshToken(boolean reuseRefreshToken) {
        this.reuseRefreshToken = reuseRefreshToken;
    }
}

