/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.password;

import java.util.Set;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.oauth2.provider.AccessGrantAuthenticationToken;
import org.springframework.security.oauth2.provider.ClientAuthenticationToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPasswordAuthenticationToken
extends AbstractAuthenticationToken {
    private final ClientAuthenticationToken clientAuthentication;
    private final UsernamePasswordAuthenticationToken userAuthentication;

    public ClientPasswordAuthenticationToken(String clientId, String clientSecret, Set<String> scope, String username, String password) {
        super(null);
        this.clientAuthentication = new AccessGrantAuthenticationToken(clientId, clientSecret, scope, "password");
        this.userAuthentication = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
    }

    public ClientAuthenticationToken getClientAuthentication() {
        return this.clientAuthentication;
    }

    public UsernamePasswordAuthenticationToken getUserAuthentication() {
        return this.userAuthentication;
    }

    public Object getPrincipal() {
        return this.userAuthentication.getPrincipal();
    }

    public Object getCredentials() {
        return this.userAuthentication.getCredentials();
    }

    public void setDetails(Object details) {
        super.setDetails(details);
        this.clientAuthentication.setDetails(details);
        this.userAuthentication.setDetails(details);
    }
}

