/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.DefaultOAuth2SerializationService;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.oauth2.common.OAuth2SerializationService;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.web.filter.GenericFilterBean;

public class OAuth2ExceptionHandlerFilter
extends GenericFilterBean {
    private OAuth2SerializationService serializationService = new DefaultOAuth2SerializationService();
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Chain processed normally");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable[] causeChain = this.getThrowableAnalyzer().determineCauseChain((Throwable)ex);
            AuthenticationException ase = (AuthenticationException)this.getThrowableAnalyzer().getFirstThrowableOfType(AuthenticationException.class, causeChain);
            if (ase == null) {
                ase = (AccessDeniedException)this.getThrowableAnalyzer().getFirstThrowableOfType(AccessDeniedException.class, causeChain);
            }
            if (ase != null) {
                this.handleSecurityException(request, response, chain, (RuntimeException)ase);
            }
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    protected void handleSecurityException(HttpServletRequest request, HttpServletResponse response, FilterChain chain, RuntimeException ase) throws IOException {
        if (ase instanceof OAuth2Exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"OAuth error.", (Throwable)ase);
            }
            String serialization = this.getSerializationService().serialize((OAuth2Exception)((Object)ase));
            response.setStatus(((OAuth2Exception)((Object)ase)).getHttpErrorCode());
            response.setHeader("Cache-Control", "no-store");
            response.setContentType("application/json");
            response.getWriter().write(serialization);
            response.flushBuffer();
            return;
        }
        throw ase;
    }

    public ThrowableAnalyzer getThrowableAnalyzer() {
        return this.throwableAnalyzer;
    }

    @Autowired(required=false)
    public void setThrowableAnalyzer(ThrowableAnalyzer throwableAnalyzer) {
        this.throwableAnalyzer = throwableAnalyzer;
    }

    public OAuth2SerializationService getSerializationService() {
        return this.serializationService;
    }

    public void setSerializationService(OAuth2SerializationService serializationService) {
        this.serializationService = serializationService;
    }
}

