/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.consumer.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.consumer.webserver.WebServerProfileResourceDetails;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class OAuth2ResourceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        if ("authorization_code".equals(element.getAttribute("type"))) {
            return WebServerProfileResourceDetails.class;
        }
        return BaseOAuth2ProtectedResourceDetails.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String scope;
        String requireImmediateAuthorization;
        String preEstablishedRedirectUri;
        String userAuthorizationUri;
        String clientAuthenticationScheme;
        String accessTokenUri;
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("An id must be supplied on a resource element.", (Object)element);
        }
        builder.addPropertyValue("id", (Object)id);
        String type = element.getAttribute("type");
        if (StringUtils.hasText((String)type)) {
            builder.addPropertyValue("grantType", (Object)type);
        }
        if (!StringUtils.hasText((String)(accessTokenUri = element.getAttribute("accessTokenUri")))) {
            parserContext.getReaderContext().error("An accessTokenUri must be supplied on a resource element.", (Object)element);
        }
        builder.addPropertyValue("accessTokenUri", (Object)accessTokenUri);
        String clientId = element.getAttribute("clientId");
        if (!StringUtils.hasText((String)clientId)) {
            parserContext.getReaderContext().error("An clientId must be supplied on a resource element.", (Object)element);
        }
        builder.addPropertyValue("clientId", (Object)clientId);
        String clientSecret = element.getAttribute("clientSecret");
        if (StringUtils.hasText((String)clientSecret)) {
            builder.addPropertyValue("secretRequired", (Object)"true");
            builder.addPropertyValue("clientSecret", (Object)clientSecret);
        }
        if (StringUtils.hasText((String)(clientAuthenticationScheme = element.getAttribute("clientAuthenticationScheme")))) {
            builder.addPropertyValue("clientAuthenticationScheme", (Object)clientAuthenticationScheme);
        }
        if (StringUtils.hasText((String)(userAuthorizationUri = element.getAttribute("userAuthorizationUri")))) {
            builder.addPropertyValue("userAuthorizationUri", (Object)userAuthorizationUri);
        }
        if (StringUtils.hasText((String)(preEstablishedRedirectUri = element.getAttribute("preEstablishedRedirectUri")))) {
            builder.addPropertyValue("preEstablishedRedirectUri", (Object)preEstablishedRedirectUri);
        }
        if (StringUtils.hasText((String)(requireImmediateAuthorization = element.getAttribute("requireImmediateAuthorization")))) {
            builder.addPropertyValue("requireImmediateAuthorization", (Object)requireImmediateAuthorization);
        }
        if (StringUtils.hasText((String)(scope = element.getAttribute("scope")))) {
            ArrayList<String> scopeList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(scope, ",");
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                scopeList.add(tok.trim());
            }
            builder.addPropertyValue("scoped", (Object)"true");
            builder.addPropertyValue("scope", scopeList);
        }
        OAuth2ProtectedResourceDetails.BearerTokenMethod btm = OAuth2ProtectedResourceDetails.BearerTokenMethod.header;
        String bearerTokenMethod = element.getAttribute("bearerTokenMethod");
        if (StringUtils.hasText((String)bearerTokenMethod)) {
            btm = OAuth2ProtectedResourceDetails.BearerTokenMethod.valueOf(bearerTokenMethod);
        }
        builder.addPropertyValue("bearerTokenMethod", (Object)btm);
        String bearerTokenName = element.getAttribute("bearerTokenName");
        if (!StringUtils.hasText((String)bearerTokenName)) {
            bearerTokenName = "oauth_token";
        }
        builder.addPropertyValue("bearerTokenName", (Object)bearerTokenName);
    }
}

