/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.oauth2.provider.AccessGrantAuthenticationProvider;
import org.springframework.security.oauth2.provider.OAuth2AuthorizationFilter;
import org.springframework.security.oauth2.provider.OAuth2AuthorizationSuccessHandler;
import org.springframework.security.oauth2.provider.OAuth2ExceptionHandlerFilter;
import org.springframework.security.oauth2.provider.OAuth2ProtectedResourceFilter;
import org.springframework.security.oauth2.provider.password.ClientPasswordAuthenticationProvider;
import org.springframework.security.oauth2.provider.refresh.RefreshAuthenticationProvider;
import org.springframework.security.oauth2.provider.token.InMemoryOAuth2ProviderTokenServices;
import org.springframework.security.oauth2.provider.verification.BasicUserApprovalFilter;
import org.springframework.security.oauth2.provider.verification.InMemoryVerificationCodeServices;
import org.springframework.security.oauth2.provider.verification.VerificationCodeAuthenticationProvider;
import org.springframework.security.oauth2.provider.verification.VerificationCodeFilter;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ProviderBeanDefinitionParser
implements BeanDefinitionParser {
    public static String OAUTH2_AUTHENTICATION_MANAGER = "OAuth2org.springframework.security.authenticationManager";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinition filterChainProxy = parserContext.getRegistry().getBeanDefinition("org.springframework.security.filterChainProxy");
        Map filterChainMap = (Map)filterChainProxy.getPropertyValues().getPropertyValue("filterChainMap").getValue();
        List<BeanMetadataElement> filterChain = this.findFilterChain(filterChainMap);
        if (filterChain == null) {
            throw new IllegalStateException("Unable to find the filter chain for the universal pattern matcher where the oauth filters are to be inserted.");
        }
        String clientDetailsRef = element.getAttribute("client-details-service-ref");
        String tokenServicesRef = element.getAttribute("token-services-ref");
        String authUrl = element.getAttribute("authorization-url");
        String defaultGrantType = element.getAttribute("default-grant-type");
        String authSuccessHandlerRef = element.getAttribute("authorization-success-handler-ref");
        String serializerRef = element.getAttribute("serialization-service-ref");
        String grantManagerRef = element.getAttribute("grant-manager-ref");
        String redirectStrategyRef = element.getAttribute("redirect-strategy-ref");
        if (!StringUtils.hasText((String)tokenServicesRef)) {
            tokenServicesRef = "oauth2TokenServices";
            BeanDefinitionBuilder tokenServices = BeanDefinitionBuilder.rootBeanDefinition(InMemoryOAuth2ProviderTokenServices.class);
            parserContext.getRegistry().registerBeanDefinition(tokenServicesRef, (BeanDefinition)tokenServices.getBeanDefinition());
        }
        if (!StringUtils.hasText((String)authSuccessHandlerRef)) {
            authSuccessHandlerRef = "oauth2AuthorizationSuccessHandler";
            BeanDefinitionBuilder successHandler = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizationSuccessHandler.class);
            successHandler.addPropertyReference("tokenServices", tokenServicesRef);
            if (StringUtils.hasText((String)serializerRef)) {
                successHandler.addPropertyReference("serializationService", serializerRef);
            }
            parserContext.getRegistry().registerBeanDefinition(authSuccessHandlerRef, (BeanDefinition)successHandler.getBeanDefinition());
        }
        BeanDefinitionBuilder clientAuthProvider = BeanDefinitionBuilder.rootBeanDefinition(AccessGrantAuthenticationProvider.class);
        if (StringUtils.hasText((String)clientDetailsRef)) {
            clientAuthProvider.addPropertyReference("clientDetailsService", clientDetailsRef);
        }
        parserContext.getRegistry().registerBeanDefinition("oauth2ClientProvider", (BeanDefinition)clientAuthProvider.getBeanDefinition());
        ManagedList providers = new ManagedList();
        providers.add(clientAuthProvider.getBeanDefinition());
        BeanDefinitionBuilder exceptionHandler = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ExceptionHandlerFilter.class);
        if (StringUtils.hasText((String)serializerRef)) {
            exceptionHandler.addPropertyReference("serializationService", serializerRef);
        }
        int filterIndex = this.insertIndex(filterChain);
        parserContext.getRegistry().registerBeanDefinition("oauth2ExceptionHandlerFilter", (BeanDefinition)exceptionHandler.getBeanDefinition());
        filterChain.add(filterIndex++, (BeanMetadataElement)new RuntimeBeanReference("oauth2ExceptionHandlerFilter"));
        Element verificationCodeElement = DomUtils.getChildElementByTagName((Element)element, (String)"verification-code");
        if (verificationCodeElement == null || !"true".equalsIgnoreCase(verificationCodeElement.getAttribute("disabled"))) {
            String approvalHandlerRef;
            String approvalPage = verificationCodeElement == null ? null : verificationCodeElement.getAttribute("user-approval-page");
            String approvalParameter = verificationCodeElement == null ? null : verificationCodeElement.getAttribute("approval-parameter-name");
            String verificationServicesRef = verificationCodeElement == null ? null : verificationCodeElement.getAttribute("services-ref");
            String redirectResolverRef = verificationCodeElement == null ? null : verificationCodeElement.getAttribute("redirect-resolver-ref");
            String authenticationCacheRef = verificationCodeElement == null ? null : verificationCodeElement.getAttribute("authentication-cache-ref");
            String approvalFilterRef = verificationCodeElement == null ? null : verificationCodeElement.getAttribute("user-approval-filter-ref");
            String string = approvalHandlerRef = verificationCodeElement == null ? null : verificationCodeElement.getAttribute("approval-handler-ref");
            if (!StringUtils.hasText((String)approvalFilterRef)) {
                approvalFilterRef = "oauth2ApprovalFilter";
                BeanDefinitionBuilder approvalFilter = BeanDefinitionBuilder.rootBeanDefinition(BasicUserApprovalFilter.class);
                parserContext.getRegistry().registerBeanDefinition(approvalFilterRef, (BeanDefinition)approvalFilter.getBeanDefinition());
                if (!StringUtils.hasText((String)approvalHandlerRef)) {
                    approvalHandlerRef = approvalFilterRef;
                }
            }
            if (!StringUtils.hasText((String)approvalHandlerRef)) {
                approvalHandlerRef = "oauth2ApprovalHandler";
                BeanDefinitionBuilder approvalHandler = BeanDefinitionBuilder.rootBeanDefinition(BasicUserApprovalFilter.class);
                if (StringUtils.hasText((String)approvalParameter)) {
                    approvalHandler.addPropertyValue("approvalParameter", (Object)approvalParameter);
                }
                if (StringUtils.hasText((String)authenticationCacheRef)) {
                    approvalHandler.addPropertyReference("authenticationCache", authenticationCacheRef);
                }
                parserContext.getRegistry().registerBeanDefinition(approvalHandlerRef, (BeanDefinition)approvalHandler.getBeanDefinition());
            }
            if (!StringUtils.hasText((String)verificationServicesRef)) {
                verificationServicesRef = "oauth2VerificationServices";
                BeanDefinitionBuilder verificationServices = BeanDefinitionBuilder.rootBeanDefinition(InMemoryVerificationCodeServices.class);
                parserContext.getRegistry().registerBeanDefinition(verificationServicesRef, (BeanDefinition)verificationServices.getBeanDefinition());
            }
            BeanDefinitionBuilder verificationCodeFilterBean = BeanDefinitionBuilder.rootBeanDefinition(VerificationCodeFilter.class);
            if (StringUtils.hasText((String)clientDetailsRef)) {
                verificationCodeFilterBean.addPropertyReference("clientDetailsService", clientDetailsRef);
            }
            if (StringUtils.hasText((String)redirectResolverRef)) {
                verificationCodeFilterBean.addPropertyReference("redirectResolver", redirectResolverRef);
            }
            if (StringUtils.hasText((String)authenticationCacheRef)) {
                verificationCodeFilterBean.addPropertyReference("authenticationCache", authenticationCacheRef);
            }
            if (StringUtils.hasText((String)redirectStrategyRef)) {
                verificationCodeFilterBean.addPropertyReference("redirectStrategy", redirectStrategyRef);
            }
            if (StringUtils.hasText((String)approvalPage)) {
                SimpleUrlAuthenticationFailureHandler approvalPageHandler = new SimpleUrlAuthenticationFailureHandler();
                approvalPageHandler.setDefaultFailureUrl(approvalPage);
                verificationCodeFilterBean.addPropertyValue("unapprovedAuthenticationHandler", (Object)approvalPageHandler);
            }
            verificationCodeFilterBean.addPropertyReference("verificationServices", verificationServicesRef);
            verificationCodeFilterBean.addPropertyReference("userApprovalHandler", approvalHandlerRef);
            BeanDefinitionBuilder verificationCodeProvider = BeanDefinitionBuilder.rootBeanDefinition(VerificationCodeAuthenticationProvider.class);
            verificationCodeProvider.addPropertyReference("authenticationManager", OAUTH2_AUTHENTICATION_MANAGER);
            verificationCodeProvider.addPropertyReference("verificationServices", verificationServicesRef);
            providers.add(verificationCodeProvider.getBeanDefinition());
            filterChain.add(0, (BeanMetadataElement)new RuntimeBeanReference(approvalFilterRef));
            parserContext.getRegistry().registerBeanDefinition("oauth2VerificationCodeFilter", (BeanDefinition)verificationCodeFilterBean.getBeanDefinition());
            int n = ++filterIndex;
            ++filterIndex;
            filterChain.add(n, (BeanMetadataElement)new RuntimeBeanReference("oauth2VerificationCodeFilter"));
        }
        BeanDefinitionBuilder clientPasswordProvider = BeanDefinitionBuilder.rootBeanDefinition(ClientPasswordAuthenticationProvider.class);
        clientPasswordProvider.addPropertyReference("authenticationManager", OAUTH2_AUTHENTICATION_MANAGER);
        providers.add(clientPasswordProvider.getBeanDefinition());
        parserContext.getRegistry().registerBeanDefinition("oauth2ClientPasswordProvider", (BeanDefinition)clientPasswordProvider.getBeanDefinition());
        BeanDefinitionBuilder refreshTokenProvider = BeanDefinitionBuilder.rootBeanDefinition(RefreshAuthenticationProvider.class);
        refreshTokenProvider.addPropertyReference("authenticationManager", OAUTH2_AUTHENTICATION_MANAGER);
        providers.add(refreshTokenProvider.getBeanDefinition());
        parserContext.getRegistry().registerBeanDefinition("oauth2RefreshProvider", (BeanDefinition)refreshTokenProvider.getBeanDefinition());
        BeanDefinitionBuilder authFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizationFilter.class);
        if (StringUtils.hasText((String)authUrl)) {
            authFilterBean.addPropertyValue("filterProcessesUrl", (Object)authUrl);
        }
        if (StringUtils.hasText((String)authSuccessHandlerRef)) {
            authFilterBean.addPropertyReference("authenticationSuccessHandler", authSuccessHandlerRef);
        }
        if (StringUtils.hasText((String)defaultGrantType)) {
            authFilterBean.addPropertyValue("defaultGrantType", (Object)defaultGrantType);
        }
        if (StringUtils.hasText((String)grantManagerRef)) {
            authFilterBean.addPropertyReference("grantManager", grantManagerRef);
        }
        authFilterBean.addPropertyReference("authenticationManager", OAUTH2_AUTHENTICATION_MANAGER);
        parserContext.getRegistry().registerBeanDefinition("oauth2AuthorizationFilter", (BeanDefinition)authFilterBean.getBeanDefinition());
        filterChain.add(filterIndex++, (BeanMetadataElement)new RuntimeBeanReference("oauth2AuthorizationFilter"));
        BeanDefinitionBuilder protectedResourceFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ProtectedResourceFilter.class);
        protectedResourceFilterBean.addPropertyReference("tokenServices", tokenServicesRef);
        parserContext.getRegistry().registerBeanDefinition("oauth2ProtectedResourceFilter", (BeanDefinition)protectedResourceFilterBean.getBeanDefinition());
        filterChain.add(filterIndex++, (BeanMetadataElement)new RuntimeBeanReference("oauth2ProtectedResourceFilter"));
        BeanDefinitionBuilder oauthProviderManagerBean = BeanDefinitionBuilder.rootBeanDefinition(ProviderManager.class);
        oauthProviderManagerBean.addPropertyReference("parent", "org.springframework.security.authenticationManager");
        oauthProviderManagerBean.addPropertyValue("providers", (Object)providers);
        parserContext.getRegistry().registerBeanDefinition(OAUTH2_AUTHENTICATION_MANAGER, (BeanDefinition)oauthProviderManagerBean.getBeanDefinition());
        return null;
    }

    protected List<BeanMetadataElement> findFilterChain(Map filterChainMap) {
        Iterator valuesIt = filterChainMap.values().iterator();
        while (valuesIt.hasNext()) {
            List filterChain = (List)valuesIt.next();
            if (valuesIt.hasNext()) continue;
            return filterChain;
        }
        return null;
    }

    private int insertIndex(List<BeanMetadataElement> filterChain) {
        for (int i = 0; i < filterChain.size(); ++i) {
            String beanName;
            BeanMetadataElement filter = filterChain.get(i);
            if (!(filter instanceof BeanDefinition) || !(beanName = ((BeanDefinition)filter).getBeanClassName()).equals(ExceptionTranslationFilter.class.getName())) continue;
            return i + 1;
        }
        return filterChain.size();
    }
}

