/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.config;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth.common.signature.SharedConsumerSecret;
import org.springframework.security.oauth.config.ProtectedResourceDetailsServiceFactoryBean;
import org.springframework.security.oauth.consumer.BaseProtectedResourceDetails;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ProtectedResourceDetailsBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        return ProtectedResourceDetailsServiceFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List consumerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"resource");
        for (Object item : consumerElements) {
            List additionalRequestHeaders;
            List additionalParameters;
            String use10a;
            String headerRealm;
            String userAuthorizationURL;
            String accessTokenURL;
            BeanDefinitionBuilder resource = BeanDefinitionBuilder.rootBeanDefinition(BaseProtectedResourceDetails.class);
            Element consumerElement = (Element)item;
            String id = consumerElement.getAttribute("id");
            if (StringUtils.hasText((String)id)) {
                resource.addPropertyValue("id", (Object)id);
            } else {
                parserContext.getReaderContext().error("A resource id must be supplied with the definition of a protected resource.", (Object)consumerElement);
            }
            String key = consumerElement.getAttribute("key");
            if (StringUtils.hasText((String)key)) {
                resource.addPropertyValue("consumerKey", (Object)key);
            } else {
                parserContext.getReaderContext().error("A consumer key must be supplied with the definition of a protected resource.", (Object)consumerElement);
            }
            String secret = consumerElement.getAttribute("secret");
            if (StringUtils.hasText((String)secret)) {
                resource.addPropertyValue("sharedSecret", (Object)new SharedConsumerSecret(secret));
            } else {
                parserContext.getReaderContext().error("A shared secret must be supplied with the definition of a resource.", (Object)consumerElement);
            }
            String requestTokenURL = consumerElement.getAttribute("request-token-url");
            if (StringUtils.hasText((String)requestTokenURL)) {
                resource.addPropertyValue("requestTokenURL", (Object)requestTokenURL);
            } else {
                parserContext.getReaderContext().error("A request token URL must be supplied with the definition of a resource.", (Object)consumerElement);
            }
            String requestTokenMethod = consumerElement.getAttribute("request-token-method");
            if (StringUtils.hasText((String)requestTokenMethod)) {
                resource.addPropertyValue("requestTokenHttpMethod", (Object)requestTokenMethod);
            }
            if (StringUtils.hasText((String)(accessTokenURL = consumerElement.getAttribute("access-token-url")))) {
                resource.addPropertyValue("accessTokenURL", (Object)accessTokenURL);
            } else {
                parserContext.getReaderContext().error("An access token URL must be supplied with the definition of a resource.", (Object)consumerElement);
            }
            String accessTokenMethod = consumerElement.getAttribute("access-token-method");
            if (StringUtils.hasText((String)accessTokenMethod)) {
                resource.addPropertyValue("accessTokenHttpMethod", (Object)accessTokenMethod);
            }
            if (StringUtils.hasText((String)(userAuthorizationURL = consumerElement.getAttribute("user-authorization-url")))) {
                resource.addPropertyValue("userAuthorizationURL", (Object)userAuthorizationURL);
            } else {
                parserContext.getReaderContext().error("A user authorization URL must be supplied with the definition of a resource.", (Object)consumerElement);
            }
            String sigMethod = consumerElement.getAttribute("signature-method");
            if (!StringUtils.hasText((String)sigMethod)) {
                sigMethod = "HMAC-SHA1";
            }
            resource.addPropertyValue("signatureMethod", (Object)sigMethod);
            String acceptsHeader = consumerElement.getAttribute("accepts-authorization-header");
            if (StringUtils.hasText((String)acceptsHeader)) {
                resource.addPropertyValue("acceptsAuthorizationHeader", (Object)Boolean.valueOf(acceptsHeader));
            }
            if (StringUtils.hasText((String)(headerRealm = consumerElement.getAttribute("authorization-header-realm")))) {
                resource.addPropertyValue("authorizationHeaderRealm", (Object)headerRealm);
            }
            if (StringUtils.hasText((String)(use10a = consumerElement.getAttribute("use10a")))) {
                resource.addPropertyValue("use10a", (Object)"true".equals(use10a));
            }
            if ((additionalParameters = DomUtils.getChildElementsByTagName((Element)consumerElement, (String)"addtionalParameter")) != null && !additionalParameters.isEmpty()) {
                HashMap<String, String> additionalParams = new HashMap<String, String>();
                for (Object additionalParameter : additionalParameters) {
                    additionalParams.put(((Element)additionalParameter).getAttribute("name"), ((Element)additionalParameter).getAttribute("value"));
                }
                resource.addPropertyValue("additionalParameters", additionalParams);
            }
            if ((additionalRequestHeaders = DomUtils.getChildElementsByTagName((Element)consumerElement, (String)"additionalRequestHeader")) != null && !additionalRequestHeaders.isEmpty()) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Object additionalParameter : additionalRequestHeaders) {
                    headers.put(((Element)additionalParameter).getAttribute("name"), ((Element)additionalParameter).getAttribute("value"));
                }
                resource.addPropertyValue("additionalRequestHeaders", headers);
            }
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)resource.getBeanDefinition());
        }
    }
}

