/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.config;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.List;
import java.util.TreeMap;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth.common.signature.RSAKeySecret;
import org.springframework.security.oauth.common.signature.SharedConsumerSecret;
import org.springframework.security.oauth.provider.BaseConsumerDetails;
import org.springframework.security.oauth.provider.InMemoryConsumerDetailsService;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ConsumerServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        return InMemoryConsumerDetailsService.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List consumerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"consumer");
        TreeMap<String, BaseConsumerDetails> consumers = new TreeMap<String, BaseConsumerDetails>();
        for (Object item : consumerElements) {
            String requiredToObtainAuthenticatedToken;
            String resourceDescription;
            String resourceName;
            String authorities;
            BaseConsumerDetails consumer = new BaseConsumerDetails();
            Element consumerElement = (Element)item;
            String key = consumerElement.getAttribute("key");
            if (StringUtils.hasText((String)key)) {
                consumer.setConsumerKey(key);
            } else {
                parserContext.getReaderContext().error("A consumer key must be supplied with the definition of a consumer.", (Object)consumerElement);
            }
            String secret = consumerElement.getAttribute("secret");
            if (secret != null) {
                String typeOfSecret = consumerElement.getAttribute("typeOfSecret");
                if ("rsa-cert".equals(typeOfSecret)) {
                    try {
                        Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(parserContext.getReaderContext().getResourceLoader().getResource(secret).getInputStream());
                        consumer.setSignatureSecret(new RSAKeySecret(cert.getPublicKey()));
                    }
                    catch (IOException e) {
                        parserContext.getReaderContext().error("RSA certificate not found at " + secret + ".", (Object)consumerElement, (Throwable)e);
                    }
                    catch (CertificateException e) {
                        parserContext.getReaderContext().error("Invalid RSA certificate at " + secret + ".", (Object)consumerElement, (Throwable)e);
                    }
                } else {
                    consumer.setSignatureSecret(new SharedConsumerSecret(secret));
                }
            } else {
                parserContext.getReaderContext().error("A consumer secret must be supplied with the definition of a consumer.", (Object)consumerElement);
            }
            String name = consumerElement.getAttribute("name");
            if (StringUtils.hasText((String)name)) {
                consumer.setConsumerName(name);
            }
            if ((authorities = consumerElement.getAttribute("authorities")) != null) {
                consumer.setAuthorities(AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities));
            }
            if ((resourceName = consumerElement.getAttribute("resourceName")) != null) {
                consumer.setResourceName(resourceName);
            }
            if ((resourceDescription = consumerElement.getAttribute("resourceDescription")) != null) {
                consumer.setResourceDescription(resourceDescription);
            }
            if ((requiredToObtainAuthenticatedToken = consumerElement.getAttribute("requiredToObtainAuthenticatedToken")) != null && "false".equalsIgnoreCase(requiredToObtainAuthenticatedToken)) {
                consumer.setRequiredToObtainAuthenticatedToken(false);
            }
            consumers.put(key, consumer);
        }
        builder.addPropertyValue("consumerDetailsStore", consumers);
    }
}

