/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.ResponseConverter;

class MockMvcResponseConverter
implements ResponseConverter<MockHttpServletResponse> {
    MockMvcResponseConverter() {
    }

    public OperationResponse convert(MockHttpServletResponse mockResponse) {
        return new OperationResponseFactory().create(HttpStatus.valueOf((int)mockResponse.getStatus()), this.extractHeaders(mockResponse), mockResponse.getContentAsByteArray());
    }

    private HttpHeaders extractHeaders(MockHttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        for (String headerName : response.getHeaderNames()) {
            for (String value : response.getHeaders(headerName)) {
                headers.add(headerName, value);
            }
        }
        return headers;
    }
}

