/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ConsumerBuilderImpl;
import org.jspecify.annotations.Nullable;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.core.PulsarTopicBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultPulsarConsumerFactory<T>
implements PulsarConsumerFactory<T> {
    private final PulsarClient pulsarClient;
    private final @Nullable List<ConsumerBuilderCustomizer<T>> defaultConfigCustomizers;
    private @Nullable PulsarTopicBuilder topicBuilder;

    public DefaultPulsarConsumerFactory(PulsarClient pulsarClient, List<ConsumerBuilderCustomizer<T>> defaultConfigCustomizers) {
        this.pulsarClient = pulsarClient;
        this.defaultConfigCustomizers = defaultConfigCustomizers;
    }

    public void setTopicBuilder(@Nullable PulsarTopicBuilder topicBuilder) {
        this.topicBuilder = topicBuilder;
    }

    @Override
    public Consumer<T> createConsumer(Schema<T> schema, @Nullable Collection<String> topics, @Nullable String subscriptionName, ConsumerBuilderCustomizer<T> customizer) {
        try {
            return this.createConsumer(schema, topics, subscriptionName, null, customizer != null ? Collections.singletonList(customizer) : null);
        }
        catch (PulsarException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PulsarException(PulsarClientException.unwrap((Throwable)ex));
        }
    }

    @Override
    public Consumer<T> createConsumer(Schema<T> schema, @Nullable Collection<String> topics, @Nullable String subscriptionName, @Nullable Map<String, String> metadataProperties, @Nullable List<ConsumerBuilderCustomizer<T>> customizers) {
        Objects.requireNonNull(schema, "Schema must be specified");
        ConsumerBuilder consumerBuilder = this.pulsarClient.newConsumer(schema);
        if (!CollectionUtils.isEmpty(this.defaultConfigCustomizers)) {
            this.defaultConfigCustomizers.forEach(customizer -> customizer.customize(consumerBuilder));
        }
        if (topics != null) {
            this.replaceTopicsOnBuilder(consumerBuilder, topics);
        }
        if (subscriptionName != null) {
            consumerBuilder.subscriptionName(subscriptionName);
        }
        if (metadataProperties != null) {
            this.replaceMetadataPropertiesOnBuilder(consumerBuilder, metadataProperties);
        }
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(customizer -> customizer.customize(consumerBuilder));
        }
        this.ensureTopicNamesFullyQualified(consumerBuilder);
        this.ensureTopicsPatternFullyQualified(consumerBuilder);
        try {
            return consumerBuilder.subscribe();
        }
        catch (PulsarClientException ex) {
            throw new PulsarException(ex);
        }
    }

    private void replaceTopicsOnBuilder(ConsumerBuilder<T> builder, Collection<String> topics) {
        ConsumerBuilderImpl builderImpl = (ConsumerBuilderImpl)builder;
        builderImpl.getConf().setTopicNames(new HashSet<String>(topics));
    }

    private void replaceMetadataPropertiesOnBuilder(ConsumerBuilder<T> builder, Map<String, String> metadataProperties) {
        ConsumerBuilderImpl builderImpl = (ConsumerBuilderImpl)builder;
        builderImpl.getConf().setProperties(new TreeMap<String, String>(metadataProperties));
    }

    protected void ensureTopicNamesFullyQualified(ConsumerBuilder<T> builder) {
        if (this.topicBuilder == null) {
            return;
        }
        ConsumerBuilderImpl builderImpl = (ConsumerBuilderImpl)builder;
        Set topics = builderImpl.getConf().getTopicNames();
        if (!CollectionUtils.isEmpty((Collection)topics)) {
            List<String> fullyQualifiedTopics = topics.stream().map(this.topicBuilder::getFullyQualifiedNameForTopic).toList();
            builderImpl.getConf().setTopicNames(new HashSet<String>(fullyQualifiedTopics));
        }
        if (builderImpl.getConf().getDeadLetterPolicy() != null) {
            DeadLetterPolicy deadLetterPolicy = builderImpl.getConf().getDeadLetterPolicy();
            this.fullyQualifyDeadLetterPolicyTopic(() -> ((DeadLetterPolicy)deadLetterPolicy).getDeadLetterTopic(), arg_0 -> ((DeadLetterPolicy)deadLetterPolicy).setDeadLetterTopic(arg_0));
            this.fullyQualifyDeadLetterPolicyTopic(() -> ((DeadLetterPolicy)deadLetterPolicy).getRetryLetterTopic(), arg_0 -> ((DeadLetterPolicy)deadLetterPolicy).setRetryLetterTopic(arg_0));
        }
    }

    protected void fullyQualifyDeadLetterPolicyTopic(Supplier<String> topicGetter, java.util.function.Consumer<String> topicSetter) {
        Assert.notNull((Object)this.topicBuilder, (String)"topicBuilder must not be null");
        String topicName = topicGetter.get();
        if (StringUtils.hasText((String)topicName)) {
            String fqTopicName = this.topicBuilder.getFullyQualifiedNameForTopic(topicName);
            topicSetter.accept(fqTopicName);
        }
    }

    protected void ensureTopicsPatternFullyQualified(ConsumerBuilder<T> builder) {
        String fqTopicsPatternStr;
        String topicsPatternStr;
        if (this.topicBuilder == null) {
            return;
        }
        ConsumerBuilderImpl builderImpl = (ConsumerBuilderImpl)builder;
        Pattern topicsPattern = builderImpl.getConf().getTopicsPattern();
        if (topicsPattern != null && StringUtils.hasText((String)topicsPattern.pattern()) && !(topicsPatternStr = topicsPattern.pattern()).equals(fqTopicsPatternStr = this.topicBuilder.getFullyQualifiedNameForTopic(topicsPatternStr))) {
            builderImpl.getConf().setTopicsPattern(Pattern.compile(fqTopicsPatternStr));
        }
    }
}

