/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.pulsar.core.ExpressionResolver;
import org.springframework.pulsar.core.Resolved;

public class DefaultExpressionResolver
implements ExpressionResolver {
    private final BeanExpressionResolver beanExpressionResolver;
    private final BeanExpressionContext beanExpressionContext;
    private final ConfigurableBeanFactory configurableBeanFactory;

    public DefaultExpressionResolver(ConfigurableBeanFactory configurableBeanFactory) {
        this.beanExpressionResolver = configurableBeanFactory.getBeanExpressionResolver();
        this.beanExpressionContext = new BeanExpressionContext(configurableBeanFactory, null);
        this.configurableBeanFactory = configurableBeanFactory;
    }

    @Override
    public Resolved<String> resolveToString(String expression) {
        String placeholdersResolved = this.configurableBeanFactory.resolveEmbeddedValue(expression);
        Object resolvedObj = this.beanExpressionResolver.evaluate(placeholdersResolved, this.beanExpressionContext);
        if (resolvedObj instanceof String) {
            String resolvedString = (String)resolvedObj;
            return Resolved.of(resolvedString);
        }
        if (resolvedObj == null) {
            return Resolved.of(null);
        }
        return Resolved.failed("The expression '%s' must resolve to a string but was: %s".formatted(expression, resolvedObj));
    }
}

