/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import org.apache.pulsar.client.api.Schema;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.config.AbstractPulsarReaderEndpoint;
import org.springframework.pulsar.config.PulsarReaderContainerFactory;
import org.springframework.pulsar.config.PulsarReaderEndpoint;
import org.springframework.pulsar.core.PulsarReaderFactory;
import org.springframework.pulsar.reader.AbstractPulsarMessageReaderContainer;
import org.springframework.pulsar.reader.PulsarMessageReaderContainer;
import org.springframework.pulsar.reader.PulsarReaderContainerProperties;
import org.springframework.pulsar.support.JavaUtils;
import org.springframework.pulsar.support.MessageConverter;

public abstract class AbstractPulsarReaderContainerFactory<C extends AbstractPulsarMessageReaderContainer<T>, T>
implements PulsarReaderContainerFactory,
ApplicationEventPublisherAware,
ApplicationContextAware {
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private final PulsarReaderFactory<? super T> readerFactory;
    private final PulsarReaderContainerProperties containerProperties;
    private Boolean autoStartup;
    private Integer phase;
    private MessageConverter messageConverter;
    private ApplicationEventPublisher applicationEventPublisher;
    private ApplicationContext applicationContext;

    protected AbstractPulsarReaderContainerFactory(PulsarReaderFactory<? super T> readerFactory, PulsarReaderContainerProperties containerProperties) {
        this.readerFactory = readerFactory;
        this.containerProperties = containerProperties;
    }

    protected PulsarReaderFactory<? super T> getReaderFactory() {
        return this.readerFactory;
    }

    public PulsarReaderContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public C createReaderContainer(PulsarReaderEndpoint<PulsarMessageReaderContainer> endpoint) {
        C instance = this.createContainerInstance(endpoint);
        JavaUtils.INSTANCE.acceptIfNotNull(endpoint.getId(), arg_0 -> instance.setBeanName(arg_0));
        if (endpoint instanceof AbstractPulsarReaderEndpoint) {
            this.configureEndpoint((AbstractPulsarReaderEndpoint)endpoint);
        }
        endpoint.setupListenerContainer((PulsarMessageReaderContainer)instance, this.messageConverter);
        this.initializeContainer(instance, endpoint);
        return instance;
    }

    protected abstract C createContainerInstance(PulsarReaderEndpoint<PulsarMessageReaderContainer> var1);

    private void configureEndpoint(AbstractPulsarReaderEndpoint<C> aplEndpoint) {
    }

    protected void initializeContainer(C instance, PulsarReaderEndpoint<PulsarMessageReaderContainer> endpoint) {
        Boolean autoStart;
        PulsarReaderContainerProperties instanceProperties = ((AbstractPulsarMessageReaderContainer)instance).getContainerProperties();
        if (instanceProperties.getSchema() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull(this.containerProperties.getSchema(), instanceProperties::setSchema);
        }
        if (instanceProperties.getSchema() == null) {
            instanceProperties.setSchema(Schema.BYTES);
        }
        if ((autoStart = endpoint.getAutoStartup()) != null) {
            ((AbstractPulsarMessageReaderContainer)instance).setAutoStartup(autoStart);
        } else if (this.autoStartup != null) {
            ((AbstractPulsarMessageReaderContainer)instance).setAutoStartup(this.autoStartup);
        }
        JavaUtils.INSTANCE.acceptIfNotNull(this.phase, arg_0 -> instance.setPhase(arg_0)).acceptIfNotNull(this.applicationContext, arg_0 -> instance.setApplicationContext(arg_0)).acceptIfNotNull(this.applicationEventPublisher, arg_0 -> instance.setApplicationEventPublisher(arg_0));
    }
}

