/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import org.apache.pulsar.client.api.Schema;

public final class SchemaUtils {
    private SchemaUtils() {
    }

    public static <T> Schema<T> getSchema(T message) {
        return SchemaUtils.getSchema(message.getClass());
    }

    public static <T> Schema<T> getSchema(Class<?> messageClass) {
        return SchemaUtils.getSchema(messageClass, true);
    }

    public static <T> Schema<T> getSchema(Class<?> messageClass, boolean returnDefault) {
        return switch (messageClass.getName()) {
            case "java.lang.String" -> Schema.STRING;
            case "[B" -> Schema.BYTES;
            case "java.lang.Byte", "byte" -> Schema.INT8;
            case "java.lang.Short", "short" -> Schema.INT16;
            case "java.lang.Integer", "int" -> Schema.INT32;
            case "java.lang.Long", "long" -> Schema.INT64;
            case "java.lang.Boolean", "boolean" -> Schema.BOOL;
            case "java.nio.ByteBuffer" -> Schema.BYTEBUFFER;
            case "java.util.Date" -> Schema.DATE;
            case "java.lang.Double", "double" -> Schema.DOUBLE;
            case "java.lang.Float", "float" -> Schema.FLOAT;
            case "java.time.Instant" -> Schema.INSTANT;
            case "java.time.LocalDate" -> Schema.LOCAL_DATE;
            case "java.time.LocalDateTime" -> Schema.LOCAL_DATE_TIME;
            case "java.time.LocalTime" -> Schema.LOCAL_TIME;
            default -> returnDefault ? Schema.BYTES : null;
        };
    }
}

