/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import io.micrometer.observation.ObservationRegistry;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.config.AbstractPulsarListenerContainerFactory;
import org.springframework.pulsar.config.PulsarListenerEndpoint;
import org.springframework.pulsar.config.PulsarListenerEndpointAdapter;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.listener.AbstractPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.ConcurrentPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConcurrentPulsarListenerContainerFactory<T>
extends AbstractPulsarListenerContainerFactory<ConcurrentPulsarMessageListenerContainer<T>, T> {
    private Integer concurrency;

    public ConcurrentPulsarListenerContainerFactory(PulsarConsumerFactory<? super T> consumerFactory, PulsarContainerProperties containerProperties, @Nullable ObservationRegistry observationRegistry) {
        super(consumerFactory, containerProperties, observationRegistry);
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    protected ConcurrentPulsarMessageListenerContainer<T> createContainerInstance(PulsarListenerEndpoint endpoint) {
        PulsarContainerProperties properties = new PulsarContainerProperties(new String[0]);
        if (!CollectionUtils.isEmpty(endpoint.getTopics())) {
            properties.setTopics(endpoint.getTopics().toArray(new String[0]));
        }
        if (StringUtils.hasText((String)endpoint.getTopicPattern())) {
            properties.setTopicsPattern(endpoint.getTopicPattern());
        }
        if (StringUtils.hasText((String)endpoint.getSubscriptionName())) {
            properties.setSubscriptionName(endpoint.getSubscriptionName());
        }
        if (endpoint.isBatchListener()) {
            properties.setBatchListener(endpoint.isBatchListener());
        }
        if (endpoint.getSubscriptionType() != null) {
            properties.setSubscriptionType(endpoint.getSubscriptionType());
        }
        properties.setSchemaType(endpoint.getSchemaType());
        return new ConcurrentPulsarMessageListenerContainer(this.getConsumerFactory(), properties, this.getObservationRegistry());
    }

    @Override
    protected void initializeContainer(ConcurrentPulsarMessageListenerContainer<T> instance, PulsarListenerEndpoint endpoint) {
        super.initializeContainer(instance, endpoint);
        if (endpoint.getConcurrency() != null) {
            instance.setConcurrency(endpoint.getConcurrency());
        } else if (this.concurrency != null) {
            instance.setConcurrency(this.concurrency);
        }
    }

    @Override
    public ConcurrentPulsarMessageListenerContainer<T> createContainer(final String ... topics) {
        PulsarListenerEndpointAdapter endpoint = new PulsarListenerEndpointAdapter(){

            @Override
            public Collection<String> getTopics() {
                return Arrays.asList(topics);
            }
        };
        AbstractPulsarMessageListenerContainer container = this.createContainerInstance(endpoint);
        this.initializeContainer((ConcurrentPulsarMessageListenerContainer<T>)container, (PulsarListenerEndpoint)endpoint);
        return container;
    }
}

