/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.support;

import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.reactive.client.api.MessageResult;
import org.springframework.messaging.Message;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static <T> MessageId extractMessageId(Message<T> message) {
        Object object = message.getHeaders().get((Object)"pulsar_message_id");
        if (object instanceof MessageId) {
            MessageId msgId = (MessageId)object;
            return msgId;
        }
        throw new IllegalStateException("Spring Message missing '%s' header".formatted("pulsar_message_id"));
    }

    public static <T> MessageResult<Void> acknowledge(Message<T> message) {
        return MessageResult.acknowledge((MessageId)MessageUtils.extractMessageId(message));
    }

    public static <T> MessageResult<Void> negativeAcknowledge(Message<T> message) {
        return MessageResult.negativeAcknowledge((MessageId)MessageUtils.extractMessageId(message));
    }
}

