/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.web.deployer.OsgiWarDeploymentException;
import org.springframework.osgi.web.deployer.WarDeployer;
import org.springframework.osgi.web.deployer.WarDeployment;
import org.springframework.util.Assert;

public abstract class AbstractWarDeployer
implements WarDeployer,
InitializingBean,
BundleContextAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private BundleContext bundleContext;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.bundleContext, (String)"bundleContext is not set");
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public WarDeployment deploy(Bundle bundle, String contextPath) throws OsgiWarDeploymentException {
        WarDeployment deployment;
        String commonMessage = "bundle [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "] at [" + contextPath + "] on server " + this.getServerInfo();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating deployment for " + commonMessage));
        }
        try {
            deployment = this.createDeployment(bundle, contextPath);
        }
        catch (Exception ex) {
            throw new OsgiWarDeploymentException("Cannot create war deployment for " + commonMessage, ex);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to deploy " + commonMessage));
        }
        try {
            this.startDeployment(deployment);
            this.log.info((Object)("Successfully deployed " + commonMessage));
        }
        catch (Exception ex) {
            throw new OsgiWarDeploymentException("Cannot create war deployment for " + commonMessage, ex);
        }
        return deployment;
    }

    protected abstract WarDeployment createDeployment(Bundle var1, String var2) throws Exception;

    protected abstract void startDeployment(WarDeployment var1) throws Exception;

    protected abstract String getServerInfo();
}

