/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.internal.util.jar.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.internal.util.jar.storage.Storage;

public class FileSystemStorage
implements Storage {
    private File storage;
    private static final String TEMP_FILE_PREFIX = "spring.osgi";

    public FileSystemStorage() {
        try {
            this.storage = File.createTempFile(TEMP_FILE_PREFIX, null);
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot create temporary file", ex);
        }
        this.storage.deleteOnExit();
    }

    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.storage));
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot return file stream", ex);
        }
    }

    public OutputStream getOutputStream() {
        try {
            return new BufferedOutputStream(new FileOutputStream(this.storage));
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot return file stream", ex);
        }
    }

    public void dispose() {
        this.storage.delete();
    }

    public Resource getResource() {
        return new FileSystemResource(this.storage);
    }
}

