/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.platform;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.knopflerfish.framework.Framework;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.test.internal.util.IOUtils;
import org.springframework.osgi.test.platform.AbstractOsgiPlatform;

public class KnopflerfishPlatform
extends AbstractOsgiPlatform {
    private BundleContext context;
    private Framework framework;
    private File kfStorageDir;

    public KnopflerfishPlatform() {
        this.toString = "Knopflerfish OSGi Platform";
    }

    Properties getPlatformProperties() {
        if (this.kfStorageDir == null) {
            this.kfStorageDir = this.createTempDir("kf");
            this.kfStorageDir.deleteOnExit();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("KF temporary storage dir is " + this.kfStorageDir.getAbsolutePath()));
            }
        }
        Properties props = new Properties();
        props.setProperty("org.osgi.framework.dir", this.kfStorageDir.getAbsolutePath());
        props.setProperty("org.knopflerfish.framework.bundlestorage", "file");
        props.setProperty("org.knopflerfish.framework.bundlestorage.file.reference", "true");
        props.setProperty("org.knopflerfish.framework.bundlestorage.file.unpack", "false");
        props.setProperty("org.knopflerfish.startlevel.use", "true");
        props.setProperty("org.knopflerfish.osgi.setcontextclassloader", "true");
        props.setProperty("org.knopflerfish.framework.exitonshutdown", "false");
        props.setProperty("org.knopflerfish.framework.patch", "false");
        props.setProperty("org.knopflerfish.framework.system.export.all", "true");
        props.setProperty("org.knopflerfish.framework.strictbootclassloading", "true");
        return props;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void start() throws Exception {
        if (this.framework == null) {
            System.getProperties().putAll((Map<?, ?>)this.getConfigurationProperties());
            this.framework = new Framework((Object)this);
            this.framework.launch(0L);
            this.context = this.framework.getSystemBundleContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.framework != null) {
            this.context = null;
            try {
                this.framework.shutdown();
            }
            finally {
                this.framework = null;
                IOUtils.delete(this.kfStorageDir);
            }
        }
    }
}

