/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.osgi.extender.OsgiApplicationContextCreator;
import org.springframework.osgi.extender.support.ApplicationContextConfiguration;
import org.springframework.osgi.extender.support.scanning.ConfigurationScanner;
import org.springframework.osgi.extender.support.scanning.DefaultConfigurationScanner;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultOsgiApplicationContextCreator
implements OsgiApplicationContextCreator {
    private static final Log log = LogFactory.getLog(DefaultOsgiApplicationContextCreator.class);
    private ConfigurationScanner configurationScanner = new DefaultConfigurationScanner();

    public DelegatedExecutionOsgiBundleApplicationContext createApplicationContext(BundleContext bundleContext) throws Exception {
        Bundle bundle = bundleContext.getBundle();
        ApplicationContextConfiguration config = new ApplicationContextConfiguration(bundle, this.configurationScanner);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created configuration " + config + " for bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
        }
        if (!config.isSpringPoweredBundle()) {
            return null;
        }
        log.info((Object)("Discovered configurations " + ObjectUtils.nullSafeToString((Object[])config.getConfigurationLocations()) + " in bundle [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "]"));
        OsgiBundleXmlApplicationContext sdoac = new OsgiBundleXmlApplicationContext(config.getConfigurationLocations());
        sdoac.setBundleContext(bundleContext);
        sdoac.setPublishContextAsService(config.isPublishContextAsService());
        return sdoac;
    }

    public void setConfigurationScanner(ConfigurationScanner configurationScanner) {
        Assert.notNull((Object)configurationScanner);
        this.configurationScanner = configurationScanner;
    }
}

