/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.blueprint.activator;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.osgi.extender.internal.blueprint.activator.ReplayEventManager;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.support.Availability;
import org.springframework.osgi.service.importer.support.CollectionType;
import org.springframework.osgi.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

class BlueprintListenerManager
implements BlueprintListener,
DisposableBean {
    private static final Log log = LogFactory.getLog(BlueprintListenerManager.class);
    private volatile DisposableBean cleanupHook;
    private volatile List<BlueprintListener> listeners;
    private volatile ReplayEventManager replayManager;

    public BlueprintListenerManager(BundleContext context) {
        this.replayManager = new ReplayEventManager(context);
        OsgiServiceCollectionProxyFactoryBean fb = new OsgiServiceCollectionProxyFactoryBean();
        fb.setBundleContext(context);
        fb.setAvailability(Availability.OPTIONAL);
        fb.setCollectionType(CollectionType.LIST);
        fb.setInterfaces(new Class[]{BlueprintListener.class});
        fb.setBeanClassLoader((ClassLoader)BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)context.getBundle()));
        fb.setListeners(new OsgiServiceLifecycleListener[]{new RegistrationReplayDelivery()});
        fb.afterPropertiesSet();
        this.cleanupHook = fb;
        this.listeners = (List)fb.getObject();
    }

    public void destroy() {
        this.replayManager.destroy();
        if (this.cleanupHook != null) {
            try {
                this.cleanupHook.destroy();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot destroy listeners collection", (Throwable)ex);
            }
            this.cleanupHook = null;
        }
    }

    public void blueprintEvent(BlueprintEvent event) {
        this.replayManager.addEvent(event);
        for (BlueprintListener listener : this.listeners) {
            try {
                listener.blueprintEvent(event);
            }
            catch (Exception ex) {
                log.warn((Object)("exception encountered when calling listener " + System.identityHashCode(listener)), (Throwable)ex);
            }
        }
    }

    private class RegistrationReplayDelivery
    implements OsgiServiceLifecycleListener {
        private RegistrationReplayDelivery() {
        }

        public void bind(Object service, Map properties) throws Exception {
            BlueprintListener listener = (BlueprintListener)service;
            BlueprintListenerManager.this.replayManager.dispatchReplayEvents(listener);
        }

        public void unbind(Object service, Map properties) throws Exception {
        }
    }
}

