/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.modulith.test.PublishedEvents;
import org.springframework.util.Assert;

class DefaultPublishedEvents
implements PublishedEvents,
ApplicationListener<ApplicationEvent> {
    private final List<Object> events;

    DefaultPublishedEvents() {
        this(Collections.emptyList());
    }

    DefaultPublishedEvents(Collection<? extends Object> events) {
        Assert.notNull(events, (String)"Events must not be null!");
        this.events = new CopyOnWriteArrayList<Object>(events);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.events.add(DefaultPublishedEvents.unwrapPayloadEvent(event));
    }

    @Override
    public <T> PublishedEvents.TypedPublishedEvents<T> ofType(Class<T> type) {
        return SimpleTypedPublishedEvents.of(this.events.stream().filter(type::isInstance).map(type::cast));
    }

    public String toString() {
        return this.events.isEmpty() ? "[]" : this.events.stream().map(Object::toString).collect(Collectors.joining("[ ", ", ", " ]"));
    }

    private static Object unwrapPayloadEvent(Object source) {
        return PayloadApplicationEvent.class.isInstance(source) ? ((PayloadApplicationEvent)source).getPayload() : source;
    }

    private static class SimpleTypedPublishedEvents<T>
    implements PublishedEvents.TypedPublishedEvents<T> {
        private final List<T> events;

        private SimpleTypedPublishedEvents(List<T> events) {
            this.events = events;
        }

        private static <T> SimpleTypedPublishedEvents<T> of(Stream<T> stream) {
            return new SimpleTypedPublishedEvents<T>(stream.toList());
        }

        @Override
        public <S> PublishedEvents.TypedPublishedEvents<S> ofType(Class<S> type) {
            return SimpleTypedPublishedEvents.of(this.getFilteredEvents(type::isInstance).map(type::cast));
        }

        @Override
        public PublishedEvents.TypedPublishedEvents<T> matching(Predicate<? super T> predicate) {
            return SimpleTypedPublishedEvents.of(this.getFilteredEvents(predicate));
        }

        @Override
        public <S> PublishedEvents.TypedPublishedEvents<T> matching(Function<T, S> mapper, Predicate<? super S> predicate) {
            return SimpleTypedPublishedEvents.of(this.events.stream().filter(it -> predicate.test((Object)mapper.apply(it))));
        }

        @Override
        public <S> PublishedEvents.TypedPublishedEvents<T> matching(Function<T, S> mapper, S value) {
            return this.matching(mapper, (S)((Predicate<Object>)it -> Objects.equals(it, value)));
        }

        private Stream<T> getFilteredEvents(Predicate<? super T> predicate) {
            return this.events.stream().filter(predicate);
        }

        @Override
        public Iterator<T> iterator() {
            return this.events.iterator();
        }

        public String toString() {
            return this.events.toString();
        }
    }
}

