/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tngtech.archunit.core.domain.JavaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.lang.Nullable;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ConfigurationProperties
implements Iterable<ConfigurationProperty> {
    private static final String METADATA_PATH = "classpath:META-INF/spring-configuration-metadata.json";
    private static final JsonPath PATH = JsonPath.compile((String)"$.properties", (Predicate[])new Predicate[0]);
    private final List<ConfigurationProperty> properties;

    ConfigurationProperties() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources(METADATA_PATH);
            this.properties = Arrays.stream(resources).flatMap(ConfigurationProperties::parseProperties).toList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ModuleProperty> getModuleProperties(ApplicationModule module) {
        Assert.notNull((Object)module, (String)"Module must not be null!");
        return this.properties.stream().flatMap(it -> this.getModuleProperty(module, (ConfigurationProperty)it)).toList();
    }

    @Override
    public Iterator<ConfigurationProperty> iterator() {
        return this.properties.iterator();
    }

    private Stream<ModuleProperty> getModuleProperty(ApplicationModule module, ConfigurationProperty property) {
        return module.getType(property.sourceType).map(it -> new ModuleProperty(property.name(), property.description(), property.type(), (JavaType)it, property.defaultValue())).map(Stream::of).orElseGet(Stream::empty);
    }

    private static Stream<ConfigurationProperty> parseProperties(Resource source) {
        Stream<ConfigurationProperty> stream;
        block9: {
            if (!source.exists()) {
                return Stream.empty();
            }
            InputStream stream2 = source.getInputStream();
            try {
                DocumentContext context = JsonPath.parse((InputStream)stream2);
                List read = (List)context.read(PATH, List.class);
                stream = read.stream().map(it -> (Map)it).flatMap(ConfigurationProperty::of);
                if (stream2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception o_O) {
                    return Stream.empty();
                }
            }
            stream2.close();
        }
        return stream;
    }

    record ConfigurationProperty(String name, @Nullable String description, String type, String sourceType, @Nullable String defaultValue) {
        static Stream<ConfigurationProperty> of(Map<String, Object> source) {
            String sourceType = ConfigurationProperty.getAsString(source, "sourceType");
            if (!StringUtils.hasText((String)sourceType)) {
                return Stream.empty();
            }
            ConfigurationProperty property = new ConfigurationProperty(ConfigurationProperty.getAsString(source, "name"), ConfigurationProperty.getAsString(source, "description"), ConfigurationProperty.getAsString(source, "type"), sourceType, ConfigurationProperty.getAsString(source, "defaultValue"));
            return Stream.of(property);
        }

        boolean hasSourceType() {
            return StringUtils.hasText((String)this.sourceType);
        }

        @Nullable
        private static String getAsString(Map<String, Object> source, String key) {
            Object value = source.get(key);
            return value == null ? null : value.toString();
        }
    }

    record ModuleProperty(String name, @Nullable String description, String type, JavaType sourceType, @Nullable String defaultValue) {
    }
}

