/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.actuator.autoconfigure;

import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.modulith.actuator.ApplicationModulesEndpoint;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.util.function.ThrowingSupplier;

@AutoConfiguration
class ApplicationModulesEndpointConfiguration {
    static final String FILE_LOCATION = "META-INF/spring-modulith/application-modules.json";
    private static final Resource PRECOMPUTED = new ClassPathResource("META-INF/spring-modulith/application-modules.json");
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModulesEndpointConfiguration.class);

    ApplicationModulesEndpointConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    ApplicationModulesEndpoint applicationModulesEndpoint(ApplicationModulesRuntime runtime) {
        if (PRECOMPUTED.exists()) {
            ThrowingSupplier fileContent = () -> PRECOMPUTED.getContentAsString(StandardCharsets.UTF_8);
            LOGGER.debug("Using application modules description from {}", (Object)FILE_LOCATION);
            return ApplicationModulesEndpoint.precomputed((Supplier<String>)fileContent);
        }
        return ApplicationModulesEndpoint.ofApplicationModules((Supplier<ApplicationModules>)runtime);
    }
}

