/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.site;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DeviceUtils;
import org.springframework.mobile.device.site.SitePreference;
import org.springframework.mobile.device.site.SitePreferenceHandler;
import org.springframework.mobile.device.site.SitePreferenceRepository;

public class StandardSitePreferenceHandler
implements SitePreferenceHandler {
    private final SitePreferenceRepository sitePreferenceRepository;
    private static final String SITE_PREFERENCE_PARAMETER = "site_preference";

    public StandardSitePreferenceHandler(SitePreferenceRepository sitePreferenceRepository) {
        this.sitePreferenceRepository = sitePreferenceRepository;
    }

    public SitePreference handleSitePreference(HttpServletRequest request, HttpServletResponse response) {
        SitePreference preference = this.getSitePreferenceQueryParameter(request);
        if (preference != null) {
            this.sitePreferenceRepository.saveSitePreference(preference, request, response);
        } else {
            preference = this.sitePreferenceRepository.loadSitePreference(request);
        }
        if (preference == null) {
            preference = this.getDefaultSitePreferenceForDevice(DeviceUtils.getCurrentDevice(request));
        }
        if (preference != null) {
            request.setAttribute("currentSitePreference", (Object)preference);
        }
        return preference;
    }

    private SitePreference getSitePreferenceQueryParameter(HttpServletRequest request) {
        String string = request.getParameter(SITE_PREFERENCE_PARAMETER);
        try {
            return string != null && string.length() > 0 ? SitePreference.valueOf(string.toUpperCase()) : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private SitePreference getDefaultSitePreferenceForDevice(Device device) {
        if (device == null) {
            return null;
        }
        return device.isMobile() ? SitePreference.MOBILE : SitePreference.NORMAL;
    }
}

