/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Tags;
import org.springframework.web.reactive.function.server.HandlerFilterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;

public class RouterFunctionMetrics {
    private final MeterRegistry registry;
    private BiFunction<ServerRequest, ServerResponse, Collection<Tag>> defaultTags = (request, response) -> Arrays.asList(RouterFunctionMetrics.method(request), RouterFunctionMetrics.status(response));

    public RouterFunctionMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public RouterFunctionMetrics defaultTags(BiFunction<ServerRequest, ServerResponse, Collection<Tag>> defaultTags) {
        this.defaultTags = defaultTags;
        return this;
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name) {
        return this.timer(name, Collections.emptyList());
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name, String ... tags) {
        return this.timer(name, Tags.zip(tags));
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name, Iterable<Tag> tags) {
        return (request, next) -> {
            long start = System.nanoTime();
            return next.handle(request).doOnSuccess(response -> {
                List<Tag> allTags = Stream.concat(StreamSupport.stream(tags.spliterator(), false), this.defaultTags.apply(request, (ServerResponse)response).stream()).collect(Collectors.toList());
                this.registry.timer(name, allTags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }).doOnError(error -> {});
        };
    }

    public static Tag method(ServerRequest request) {
        return Tag.of("method", request.method().toString());
    }

    public static Tag status(ServerResponse response) {
        return Tag.of("status", response.statusCode().toString());
    }
}

