/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.stats.hist;

import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.metrics.instrument.internal.TimeUtils;
import org.springframework.metrics.instrument.stats.hist.CumulativeBucketFunction;
import org.springframework.metrics.instrument.stats.hist.CumulativeHistogram;
import org.springframework.metrics.instrument.stats.hist.FixedCumulativeBucketFunction;

public class TimeScaleCumulativeHistogram
extends CumulativeHistogram<Double> {
    private final TimeUnit timeScale;

    public TimeScaleCumulativeHistogram(CumulativeBucketFunction<Double> f, TimeUnit timeScale) {
        super(f);
        this.timeScale = timeScale;
    }

    public TimeScaleCumulativeHistogram shiftScale(TimeUnit targetUnit) {
        if (targetUnit.equals((Object)this.timeScale)) {
            return this;
        }
        return new TimeScaleCumulativeHistogram(new ScaledCumulativeBucketFunction(this.timeScale, targetUnit), targetUnit);
    }

    class ScaledCumulativeBucketFunction
    extends FixedCumulativeBucketFunction<Double> {
        ScaledCumulativeBucketFunction(TimeUnit sourceUnit, TimeUnit targetUnit) {
            super((double d) -> d, TimeScaleCumulativeHistogram.this.f.buckets().stream().map(d -> TimeUtils.convert(d, sourceUnit, targetUnit)).collect(Collectors.toSet()), TimeScaleCumulativeHistogram.this.f.bucketComparator());
        }
    }
}

