/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.spectator;

import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Timer;
import java.util.concurrent.TimeUnit;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.internal.AbstractTimer;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.internal.TimeUtils;
import org.springframework.metrics.instrument.spectator.SpectatorUtils;

public class SpectatorTimer
extends AbstractTimer {
    private Timer timer;

    SpectatorTimer(Timer timer, Clock clock) {
        super(new MeterId(timer.id().name(), SpectatorUtils.tags((Meter)timer)), clock);
        this.timer = timer;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.timer.record(unit.toNanos(amount), TimeUnit.NANOSECONDS);
    }

    @Override
    public long count() {
        return this.timer.count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.timer.totalTime(), unit);
    }

    @Override
    public Iterable<Measurement> measure() {
        return SpectatorUtils.measurements((Meter)this.timer);
    }
}

