/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.util.Arrays;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.springframework.metrics.instrument.DistributionSummary;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.simple.AbstractSimpleMeter;
import org.springframework.metrics.instrument.simple.SimpleUtils;

public class SimpleDistributionSummary
extends AbstractSimpleMeter
implements DistributionSummary {
    private LongAdder count = new LongAdder();
    private DoubleAdder amount = new DoubleAdder();

    SimpleDistributionSummary(MeterId id) {
        super(id);
    }

    @Override
    public void record(double amount) {
        if (amount >= 0.0) {
            this.count.increment();
            this.amount.add(amount);
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalAmount() {
        return this.amount.doubleValue();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "count")).measurement(this.count()), this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "amount")).measurement(this.totalAmount()));
    }
}

