/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.util.Collections;
import java.util.concurrent.atomic.DoubleAdder;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.simple.AbstractSimpleMeter;
import org.springframework.metrics.instrument.simple.SimpleUtils;

public class SimpleCounter
extends AbstractSimpleMeter
implements Counter {
    private DoubleAdder count = new DoubleAdder();

    SimpleCounter(MeterId id) {
        super(id);
    }

    @Override
    public void increment() {
        this.count.add(1.0);
    }

    @Override
    public void increment(double amount) {
        this.count.add(amount);
    }

    @Override
    public double count() {
        return this.count.doubleValue();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.singletonList(this.id.withTags(SimpleUtils.typeTag(this.getType())).measurement(this.count()));
    }
}

