/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.DistributionSummary;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.internal.AbstractMeterRegistry;
import org.springframework.metrics.instrument.internal.MapAccess;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.prometheus.CustomPrometheusLongTaskTimer;
import org.springframework.metrics.instrument.prometheus.CustomPrometheusSummary;
import org.springframework.metrics.instrument.prometheus.PrometheusCounter;
import org.springframework.metrics.instrument.prometheus.PrometheusDistributionSummary;
import org.springframework.metrics.instrument.prometheus.PrometheusGauge;
import org.springframework.metrics.instrument.prometheus.PrometheusLongTaskTimer;
import org.springframework.metrics.instrument.prometheus.PrometheusTimer;
import org.springframework.metrics.instrument.stats.hist.Histogram;
import org.springframework.metrics.instrument.stats.quantile.Quantiles;

public class PrometheusMeterRegistry
extends AbstractMeterRegistry {
    private final CollectorRegistry registry;
    private final ConcurrentMap<String, Collector> collectorMap = new ConcurrentHashMap<String, Collector>();
    private final ConcurrentMap<MeterId, Meter> meterMap = new ConcurrentHashMap<MeterId, Meter>();

    public PrometheusMeterRegistry() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusMeterRegistry(CollectorRegistry registry) {
        this(registry, Clock.SYSTEM);
    }

    @Autowired
    public PrometheusMeterRegistry(CollectorRegistry registry, Clock clock) {
        super(clock);
        this.registry = registry;
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).filter(mClass::isInstance).map(mClass::cast);
    }

    @Override
    public Optional<Meter> findMeter(Meter.Type type, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).filter(m -> m.getType().equals((Object)type));
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        MeterId id = new MeterId(name, tags);
        io.prometheus.client.Counter counter = this.collectorByName(io.prometheus.client.Counter.class, name, n -> (io.prometheus.client.Counter)this.buildCollector(id, (SimpleCollector.Builder)io.prometheus.client.Counter.build()));
        return MapAccess.computeIfAbsent(this.meterMap, id, c -> new PrometheusCounter(id, (Counter.Child)this.child(counter, id.getTags())));
    }

    @Override
    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        MeterId id = new MeterId(name, tags);
        CustomPrometheusSummary summary = this.collectorByName(CustomPrometheusSummary.class, name, n -> (CustomPrometheusSummary)new CustomPrometheusSummary(name, StreamSupport.stream(tags.spliterator(), false).map(Tag::getKey).collect(Collectors.toList())).register(this.registry));
        return MapAccess.computeIfAbsent(this.meterMap, id, t -> new PrometheusDistributionSummary(id, summary.child(tags, quantiles, histogram)));
    }

    @Override
    protected Timer timer(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        MeterId id = new MeterId(name, tags);
        CustomPrometheusSummary summary = this.collectorByName(CustomPrometheusSummary.class, name, n -> (CustomPrometheusSummary)new CustomPrometheusSummary(name, StreamSupport.stream(tags.spliterator(), false).map(Tag::getKey).collect(Collectors.toList())).register(this.registry));
        return MapAccess.computeIfAbsent(this.meterMap, id, t -> new PrometheusTimer(id, summary.child(tags, quantiles, histogram), this.getClock()));
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        MeterId id = new MeterId(name, tags);
        CustomPrometheusLongTaskTimer longTaskTimer = this.collectorByName(CustomPrometheusLongTaskTimer.class, name, n -> (CustomPrometheusLongTaskTimer)new CustomPrometheusLongTaskTimer(name, StreamSupport.stream(tags.spliterator(), false).map(Tag::getKey).collect(Collectors.toList()), this.getClock()).register(this.registry));
        return MapAccess.computeIfAbsent(this.meterMap, id, t -> new PrometheusLongTaskTimer(id, longTaskTimer.child(tags)));
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, final ToDoubleFunction<T> f) {
        final WeakReference ref = new WeakReference(obj);
        MeterId id = new MeterId(name, tags);
        Gauge gauge = this.collectorByName(Gauge.class, name, i -> (Gauge)this.buildCollector(id, (SimpleCollector.Builder)Gauge.build()));
        MapAccess.computeIfAbsent(this.meterMap, id, g -> {
            String[] labelValues = id.getTags().stream().map(Tag::getValue).collect(Collectors.toList()).toArray(new String[0]);
            Gauge.Child child = new Gauge.Child(){

                public double get() {
                    Object obj = ref.get();
                    return obj == null ? Double.NaN : f.applyAsDouble(obj);
                }
            };
            gauge.setChild((Object)child, labelValues);
            return new PrometheusGauge(id, child);
        });
        return obj;
    }

    @Override
    public MeterRegistry register(final Meter meter) {
        Collector collector = new Collector(){

            public List<Collector.MetricFamilySamples> collect() {
                List samples = StreamSupport.stream(meter.measure().spliterator(), false).map(m -> {
                    ArrayList<String> tagKeys = new ArrayList<String>(m.getTags().size());
                    ArrayList<String> tagValues = new ArrayList<String>(m.getTags().size());
                    for (Tag tag : m.getTags()) {
                        tagKeys.add(tag.getKey());
                        tagValues.add(tag.getValue());
                    }
                    return new Collector.MetricFamilySamples.Sample(m.getName(), tagKeys, tagValues, m.getValue());
                }).collect(Collectors.toList());
                Collector.Type type = Collector.Type.UNTYPED;
                switch (meter.getType()) {
                    case Counter: {
                        type = Collector.Type.COUNTER;
                        break;
                    }
                    case Gauge: {
                        type = Collector.Type.GAUGE;
                        break;
                    }
                    case DistributionSummary: 
                    case Timer: {
                        type = Collector.Type.SUMMARY;
                    }
                }
                return Collections.singletonList(new Collector.MetricFamilySamples(meter.getName(), type, " ", samples));
            }
        };
        this.registry.register(collector);
        this.collectorMap.put(meter.getName(), collector);
        this.meterMap.put(new MeterId(meter.getName(), meter.getTags()), meter);
        return this;
    }

    public CollectorRegistry getPrometheusRegistry() {
        return this.registry;
    }

    private <B extends SimpleCollector.Builder<B, C>, C extends SimpleCollector<D>, D> C buildCollector(MeterId id, SimpleCollector.Builder<B, C> builder) {
        return (C)builder.name(id.getName()).help(" ").labelNames(id.getTags().stream().map(Tag::getKey).collect(Collectors.toList()).toArray(new String[0])).register(this.registry);
    }

    private <C extends SimpleCollector<D>, D> D child(C collector, List<Tag> tags) {
        return (D)collector.labels(tags.stream().map(Tag::getValue).collect(Collectors.toList()).toArray(new String[0]));
    }

    private <C extends Collector> C collectorByName(Class<C> collectorType, String name, Function<String, C> ifAbsent) {
        Collector collector = (Collector)MapAccess.computeIfAbsent(this.collectorMap, name, ifAbsent);
        if (!collectorType.isInstance(collector)) {
            throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
        }
        return (C)collector;
    }
}

